/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.extension.internal.loader.java.JavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderExtensionsManagerConfigurationBuilder
extends AbstractConfigurationBuilder {
    private static Logger LOGGER = LoggerFactory.getLogger(IsolatedClassLoaderExtensionsManagerConfigurationBuilder.class);
    private final ExtensionManagerFactory extensionManagerFactory = new DefaultExtensionManagerFactory();
    private final List<ArtifactClassLoader> pluginsClassLoaders;

    public IsolatedClassLoaderExtensionsManagerConfigurationBuilder(List<ArtifactClassLoader> pluginsClassLoaders) {
        this.pluginsClassLoaders = pluginsClassLoaders;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ExtensionManager extensionManager = this.createExtensionManager(muleContext);
        for (ArtifactClassLoader pluginClassLoader : this.pluginsClassLoaders) {
            String artifactName = (String)pluginClassLoader.getClass().getMethod("getArtifactId", new Class[0]).invoke((Object)pluginClassLoader, new Object[0]);
            ClassLoader classLoader = (ClassLoader)pluginClassLoader.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)pluginClassLoader, new Object[0]);
            URL manifestUrl = this.getExtensionManifest(classLoader);
            if (manifestUrl != null) {
                LOGGER.debug("Discovered extension: {}", (Object)artifactName);
                ExtensionManifest extensionManifest = extensionManager.parseExtensionManifestXml(manifestUrl);
                HashMap params = new HashMap();
                params.put("type", extensionManifest.getDescriberManifest().getProperties().get("type"));
                params.put("version", extensionManifest.getVersion());
                extensionManager.registerExtension(new JavaExtensionModelLoader().loadExtensionModel(classLoader, params));
                continue;
            }
            LOGGER.debug("Discarding plugin artifact class loader with artifactName '{}' due to it doesn't have an extension descriptor", (Object)artifactName);
        }
    }

    private URL getExtensionManifest(ClassLoader classLoader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method findResourceMethod = classLoader.getClass().getMethod("findResource", String.class);
        findResourceMethod.setAccessible(true);
        return (URL)findResourceMethod.invoke((Object)classLoader, "META-INF/extension-manifest.xml");
    }

    private ExtensionManager createExtensionManager(MuleContext muleContext) throws InitialisationException {
        if (muleContext.getExtensionManager() != null) {
            return muleContext.getExtensionManager();
        }
        ExtensionManager extensionManager = this.extensionManagerFactory.create(muleContext);
        ((DefaultMuleContext)muleContext).setExtensionManager(extensionManager);
        return extensionManager;
    }
}

