/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classification;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.test.runner.api.WorkspaceLocationResolver;
import org.mule.test.runner.maven.MavenModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkspaceReader
implements WorkspaceReader {
    private static final String WORKSPACE = "workspace";
    private static final String MAVEN_SHADE_PLUGIN_ARTIFACT_ID = "maven-shade-plugin";
    private static final String ORG_APACHE_MAVEN_PLUGINS_GROUP_ID = "org.apache.maven.plugins";
    private static final String REDUCED_POM_XML = "dependency-reduced-pom.xml";
    private static final String POM = "pom";
    private static final String POM_XML = "pom.xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WorkspaceRepository workspaceRepository = new WorkspaceRepository("workspace");
    private final WorkspaceLocationResolver workspaceLocationResolver;
    private final List<URL> classPath;

    public DefaultWorkspaceReader(List<URL> classPath, WorkspaceLocationResolver workspaceLocationResolver) {
        Preconditions.checkNotNull(classPath, (String)"classPath cannot be null");
        Preconditions.checkNotNull((Object)workspaceLocationResolver, (String)"workspaceLocationResolver cannot be null");
        this.classPath = classPath;
        this.workspaceLocationResolver = workspaceLocationResolver;
    }

    public static File findClassPathURL(Artifact artifact, File workspaceArtifactPath, List<URL> classPath) {
        Path moduleFolder = new File(workspaceArtifactPath.getAbsoluteFile(), "target").toPath();
        StringBuilder explodedUrlSuffix = new StringBuilder();
        StringBuilder packagedUrlSuffix = new StringBuilder();
        if (DefaultWorkspaceReader.isTestArtifact(artifact)) {
            explodedUrlSuffix.append("test-classes");
            packagedUrlSuffix.append(".*-tests.jar");
        } else {
            explodedUrlSuffix.append("classes");
            packagedUrlSuffix.append("^(?!.*?(?:-tests.jar)).*.jar");
        }
        Optional<URL> localFile = classPath.stream().filter(url -> {
            Path path = FileUtils.toFile((URL)url).toPath();
            if (path.startsWith(moduleFolder)) {
                String file = path.getFileName().toFile().getName();
                return file.matches(explodedUrlSuffix.toString()) || file.matches(packagedUrlSuffix.toString());
            }
            return false;
        }).findFirst();
        if (!localFile.isPresent()) {
            return null;
        }
        return FileUtils.toFile((URL)localFile.get());
    }

    public static boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }

    public WorkspaceRepository getRepository() {
        return this.workspaceRepository;
    }

    public File findArtifact(Artifact artifact) {
        File workspaceArtifactPath = this.workspaceLocationResolver.resolvePath(artifact.getArtifactId());
        if (workspaceArtifactPath == null) {
            return null;
        }
        File artifactFile = artifact.getExtension().equals(POM) ? this.findPomFile(artifact, workspaceArtifactPath) : DefaultWorkspaceReader.findClassPathURL(artifact, workspaceArtifactPath, this.classPath);
        if (artifactFile != null && artifactFile.exists()) {
            return artifactFile.getAbsoluteFile();
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    private File findPomFile(Artifact artifact, File workspacePath) {
        Plugin shadeMavenPlugin = this.searchForMavenShadePlugin(MavenModelFactory.createMavenProject(new File(workspacePath, POM_XML)));
        if (shadeMavenPlugin != null) {
            File reducedPom = new File(workspacePath, REDUCED_POM_XML);
            if (!reducedPom.exists()) {
                throw new IllegalStateException(artifact + " has in its build configure the " + shadeMavenPlugin + " but default " + REDUCED_POM_XML + " is not present. Run the plugin first.");
            }
            this.logger.debug("Using {} for artifact {}", (Object)reducedPom, (Object)artifact);
            return reducedPom;
        }
        return new File(workspacePath, POM_XML);
    }

    private Plugin searchForMavenShadePlugin(Model model) {
        if (model.getBuild() != null) {
            for (Plugin plugin : model.getBuild().getPlugins()) {
                if (!plugin.getGroupId().equals(ORG_APACHE_MAVEN_PLUGINS_GROUP_ID) || !plugin.getArtifactId().equals(MAVEN_SHADE_PLUGIN_ARTIFACT_ID)) continue;
                return plugin;
            }
        }
        return null;
    }
}

