/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.TestClass;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.mule.test.runner.ContainerClassLoaderAware;
import org.mule.test.runner.PluginClassLoadersAware;
import org.mule.test.runner.RunnerConfiguration;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.runner.ServiceClassLoadersAware;
import org.mule.test.runner.api.AetherClassPathClassifier;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactClassificationTypeResolver;
import org.mule.test.runner.api.ArtifactIsolatedClassLoaderBuilder;
import org.mule.test.runner.api.ClassPathUrlProvider;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.RepositorySystemFactory;
import org.mule.test.runner.maven.AutoDiscoverWorkspaceLocationResolver;
import org.mule.test.runner.utils.AnnotationUtils;
import org.mule.test.runner.utils.RunnerModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactClassLoaderRunner
extends Runner
implements Filterable {
    private static final String USER_HOME = "user.home";
    private static final String M2_REPO = "/.m2/repository";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactClassLoaderRunner.class);
    private static String userHome = System.getProperty("user.home");
    private static ArtifactClassLoaderHolder artifactClassLoaderHolder;
    private static RunnerConfiguration runnerConfiguration;
    private static Exception errorCreatingClassLoaderTestRunner;
    private static boolean staticFieldsInjected;
    private final Runner delegate;

    public ArtifactClassLoaderRunner(Class<?> clazz, RunnerBuilder builder) throws Throwable {
        if (errorCreatingClassLoaderTestRunner != null) {
            throw errorCreatingClassLoaderTestRunner;
        }
        if (artifactClassLoaderHolder == null) {
            try {
                runnerConfiguration = RunnerConfiguration.readConfiguration(clazz);
                artifactClassLoaderHolder = ArtifactClassLoaderRunner.createClassLoaderTestRunner(clazz, runnerConfiguration);
            }
            catch (Exception e) {
                errorCreatingClassLoaderTestRunner = e;
                throw e;
            }
        } else {
            this.checkConfiguration(clazz);
        }
        Class<?> isolatedTestClass = this.getTestClass(clazz);
        Class<?> runnerDelegateToClass = artifactClassLoaderHolder.loadClassWithApplicationClassLoader(RunnerDelegateTo.class.getName());
        AnnotatedBuilder annotatedBuilder = new AnnotatedBuilder(builder);
        this.delegate = annotatedBuilder.buildRunner((Class)AnnotationUtils.getAnnotationAttributeFrom(isolatedTestClass, runnerDelegateToClass, "value"), isolatedTestClass);
        if (!staticFieldsInjected) {
            ArtifactClassLoaderRunner.injectPluginsClassLoaders(artifactClassLoaderHolder, isolatedTestClass);
            ArtifactClassLoaderRunner.injectServicesClassLoaders(artifactClassLoaderHolder, isolatedTestClass);
            ArtifactClassLoaderRunner.injectContainerClassLoader(artifactClassLoaderHolder, isolatedTestClass);
            staticFieldsInjected = true;
        }
    }

    private void checkConfiguration(Class<?> klass) {
        RunnerConfiguration testRunnerConfiguration = RunnerConfiguration.readConfiguration(klass);
        if (!runnerConfiguration.equals(testRunnerConfiguration)) {
            throw new IllegalArgumentException("Invalid configuration defined for test: " + klass + " . Is not supported to have multiple configurations of the runner because class loaders are created only once for all the tests in the module. Current configuration loaded was: " + runnerConfiguration + " but configuration obtained from test class was: " + testRunnerConfiguration);
        }
    }

    private static synchronized ArtifactClassLoaderHolder createClassLoaderTestRunner(Class<?> klass, RunnerConfiguration runnerConfiguration) {
        Properties excludedProperties;
        File targetTestClassesFolder = new File(klass.getProtectionDomain().getCodeSource().getLocation().getPath());
        ArtifactIsolatedClassLoaderBuilder builder = new ArtifactIsolatedClassLoaderBuilder();
        File rootArtifactClassesFolder = new File(targetTestClassesFolder.getParentFile(), "classes");
        builder.setRootArtifactClassesFolder(rootArtifactClassesFolder);
        builder.setPluginResourcesFolder(targetTestClassesFolder.getParentFile());
        builder.setProvidedExclusions(runnerConfiguration.getProvidedExclusions());
        builder.setProvidedInclusions(runnerConfiguration.getProvidedInclusions());
        builder.setTestExclusions(runnerConfiguration.getTestExclusions());
        builder.setTestInclusions(runnerConfiguration.getTestInclusions());
        builder.setExportPluginClasses(runnerConfiguration.getExportPluginClasses());
        builder.setPluginCoordinates(runnerConfiguration.getPlugins());
        builder.setSharedPluginLibCoordinates(runnerConfiguration.getSharedRuntimeLibs());
        builder.setExtensionMetadataGeneration(true);
        try {
            excludedProperties = RunnerModuleUtils.getExcludedProperties();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading excluded properties", e);
        }
        List<String> excludedArtifactsList = ArtifactClassLoaderRunner.getExcludedArtifacts(excludedProperties);
        builder.setExcludedArtifacts(excludedArtifactsList);
        builder.setExtraBootPackages(ArtifactClassLoaderRunner.getExtraBootPackages(excludedProperties));
        ClassPathUrlProvider classPathUrlProvider = new ClassPathUrlProvider();
        List<URL> classPath = classPathUrlProvider.getURLs();
        builder.setClassPathUrlProvider(classPathUrlProvider);
        AutoDiscoverWorkspaceLocationResolver workspaceLocationResolver = new AutoDiscoverWorkspaceLocationResolver(classPath, rootArtifactClassesFolder);
        DependencyResolver dependencyResolver = RepositorySystemFactory.newOfflineDependencyResolver(classPath, workspaceLocationResolver, ArtifactClassLoaderRunner.getMavenLocalRepository());
        builder.setClassPathClassifier(new AetherClassPathClassifier(dependencyResolver, new ArtifactClassificationTypeResolver(dependencyResolver)));
        return builder.build();
    }

    private static List<String> getExcludedArtifacts(Properties excludedProperties) {
        String excludedArtifacts = excludedProperties.getProperty("excluded.artifacts");
        ArrayList excludedArtifactsList = Lists.newArrayList();
        if (excludedArtifacts != null) {
            for (String exclusion : excludedArtifacts.split(",")) {
                excludedArtifactsList.add(exclusion);
            }
        }
        return excludedArtifactsList;
    }

    private static List<String> getExtraBootPackages(Properties excludedProperties) {
        HashSet packages = Sets.newHashSet();
        String excludedExtraBootPackages = excludedProperties.getProperty("extraBoot.packages");
        if (excludedExtraBootPackages != null) {
            for (String extraBootPackage : excludedExtraBootPackages.split(",")) {
                packages.add(extraBootPackage);
            }
        } else {
            LOGGER.warn("excluded.properties found but there is no list of extra boot packages defined to be added to container, this could be the reason why the test may fail later due to JUnit classes are not found");
        }
        return Lists.newArrayList((Iterable)packages);
    }

    private static <E> List<E> readAttribute(String name, Class<?> klass) {
        List valuesList = AnnotationUtils.getAnnotationAttributeFromHierarchy(klass, ArtifactClassLoaderRunnerConfig.class, name);
        return valuesList.stream().flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    private static File getMavenLocalRepository() {
        String localRepositoryProperty = System.getProperty("localRepository");
        if (localRepositoryProperty == null) {
            localRepositoryProperty = userHome + M2_REPO;
            LOGGER.debug("System property 'localRepository' not set, using Maven default location: $USER_HOME{}", (Object)M2_REPO);
        }
        LOGGER.debug("Using Maven localRepository: '{}'", (Object)localRepositoryProperty);
        File mavenLocalRepositoryLocation = new File(localRepositoryProperty);
        if (!mavenLocalRepositoryLocation.exists()) {
            throw new IllegalArgumentException("Maven repository location couldn't be found, please check your configuration");
        }
        return mavenLocalRepositoryLocation;
    }

    private static void injectPluginsClassLoaders(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<PluginClassLoadersAware> pluginClassLoadersAwareClass = PluginClassLoadersAware.class;
        String expectedParamType = "List<" + ArtifactClassLoader.class + ">";
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, pluginClassLoadersAwareClass, expectedParamType);
        List<ArtifactClassLoader> valueToInject = artifactClassLoaderHolder.getPluginsClassLoaders();
        ArtifactClassLoaderRunner.doFieldInjection(pluginClassLoadersAwareClass, method, valueToInject, expectedParamType);
    }

    private static void injectServicesClassLoaders(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<ServiceClassLoadersAware> serviceClassLoadersAwareClass = ServiceClassLoadersAware.class;
        String expectedParamType = "List<" + ArtifactClassLoader.class + ">";
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, serviceClassLoadersAwareClass, expectedParamType);
        List<ArtifactClassLoader> valueToInject = artifactClassLoaderHolder.getServicesClassLoaders();
        ArtifactClassLoaderRunner.doFieldInjection(serviceClassLoadersAwareClass, method, valueToInject, expectedParamType);
    }

    private static void injectContainerClassLoader(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<ContainerClassLoaderAware> containerClassLoaderAwareClass = ContainerClassLoaderAware.class;
        String expectedParamType = ArtifactClassLoader.class.getName();
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, containerClassLoaderAwareClass, expectedParamType);
        ArtifactClassLoader containerClassLoader = artifactClassLoaderHolder.getContainerClassLoader();
        Field artifactClassLoaderField = containerClassLoader.getClass().getSuperclass().getDeclaredField("artifactClassLoader");
        artifactClassLoaderField.setAccessible(true);
        Object valueToInject = artifactClassLoaderField.get(containerClassLoader);
        ArtifactClassLoaderRunner.doFieldInjection(containerClassLoaderAwareClass, method, valueToInject, expectedParamType);
    }

    private static void doFieldInjection(Class<? extends Annotation> containerClassLoaderAwareClass, FrameworkMethod method, Object value, String expectedParamType) throws Throwable {
        method.getMethod().setAccessible(true);
        try {
            method.invokeExplosively(null, new Object[]{value});
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Method marked with annotation " + containerClassLoaderAwareClass.getName() + " should receive a parameter of type " + expectedParamType);
        }
        finally {
            method.getMethod().setAccessible(false);
        }
    }

    private static FrameworkMethod getAnnotatedMethod(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass, Class<? extends Annotation> annotationClass, String expectedParamType) throws ClassNotFoundException {
        TestClass testClass = new TestClass(isolatedTestClass);
        Class<?> artifactContextAwareAnn = artifactClassLoaderHolder.loadClassWithApplicationClassLoader(annotationClass.getName());
        List contextAwareMethods = testClass.getAnnotatedMethods(artifactContextAwareAnn);
        if (contextAwareMethods.size() != 1) {
            throw new IllegalStateException("Isolation tests need to have one method marked with annotation " + annotationClass.getName());
        }
        FrameworkMethod method = (FrameworkMethod)contextAwareMethods.get(0);
        if (!method.isStatic() || method.isPublic()) {
            throw new IllegalStateException("Method marked with annotation " + annotationClass.getName() + " should be private static and receive a parameter of type " + expectedParamType);
        }
        return method;
    }

    private Class<?> getTestClass(Class<?> clazz) throws InitializationError {
        try {
            return artifactClassLoaderHolder.loadClassWithApplicationClassLoader(clazz.getName());
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoaderHolder.getApplicationClassLoader().getClassLoader(), () -> this.delegate.run(notifier));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.delegate instanceof Filterable) {
            ((Filterable)this.delegate).filter(filter);
        }
    }

    static {
        staticFieldsInjected = false;
    }
}

