/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Properties;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.util.PropertiesUtils;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.test.runner.api.PluginUrlClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourcesResolver {
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String COMMA_CHARACTER = ",";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExtensionManager extensionManager;

    public PluginResourcesResolver(ExtensionManager extensionManager) {
        Preconditions.checkNotNull((Object)extensionManager, (String)"extensionManager cannot be null");
        this.extensionManager = extensionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginUrlClassification resolvePluginResourcesFor(PluginUrlClassification pluginUrlClassification) {
        try (URLClassLoader classLoader = new URLClassLoader(pluginUrlClassification.getUrls().toArray(new URL[0]), null);){
            HashSet exportResources;
            HashSet exportPackages;
            URL manifestUrl = classLoader.findResource("META-INF/extension-manifest.xml");
            if (manifestUrl != null) {
                this.logger.debug("Plugin '{}' has extension descriptor therefore it will be handled as an extension", (Object)pluginUrlClassification.getName());
                ExtensionManifest extensionManifest = this.extensionManager.parseExtensionManifestXml(manifestUrl);
                exportPackages = Sets.newHashSet((Iterable)extensionManifest.getExportedPackages());
                exportResources = Sets.newHashSet((Iterable)extensionManifest.getExportedResources());
            } else {
                Properties pluginProperties;
                this.logger.debug("Plugin '{}' will be handled as standard plugin", (Object)pluginUrlClassification.getName());
                URL pluginPropertiesUrl = classLoader.getResource(PLUGIN_PROPERTIES);
                if (pluginPropertiesUrl == null) {
                    throw new IllegalStateException("plugin.properties couldn't be found for plugin: " + pluginUrlClassification.getName());
                }
                try {
                    pluginProperties = PropertiesUtils.loadProperties((URL)pluginPropertiesUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading plugin properties: " + pluginPropertiesUrl);
                }
                exportPackages = Sets.newHashSet((Object[])pluginProperties.getProperty("artifact.export.classPackages").split(COMMA_CHARACTER));
                exportResources = Sets.newHashSet((Object[])pluginProperties.getProperty("artifact.export.resources").split(COMMA_CHARACTER));
            }
            PluginUrlClassification pluginUrlClassification2 = new PluginUrlClassification(pluginUrlClassification.getName(), pluginUrlClassification.getUrls(), pluginUrlClassification.getExportClasses(), pluginUrlClassification.getPluginDependencies(), exportPackages, exportResources);
            return pluginUrlClassification2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

