/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.lang.ArrayUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.loader.java.JavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.util.NullDslResolvingContext;
import org.mule.test.runner.infrastructure.ExtensionsTestDslResourcesGenerator;
import org.mule.test.runner.infrastructure.ExtensionsTestLoaderResourcesGenerator;

public class ExtensionsTestInfrastructureDiscoverer {
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private final ExtensionManager extensionManager;

    public ExtensionsTestInfrastructureDiscoverer(ExtensionManager extensionManagerAdapter) {
        this.extensionManager = extensionManagerAdapter;
    }

    public void discoverExtensions(Class<?>[] annotatedClasses) {
        if (!ArrayUtils.isEmpty((Object[])annotatedClasses)) {
            Arrays.stream(annotatedClasses).forEach(c -> this.discoverExtension((Class<?>)c));
        }
    }

    public ExtensionModel discoverExtension(Class<?> annotatedClass) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", annotatedClass.getName());
        params.put("version", MuleManifest.getProductVersion());
        ExtensionModel model = new JavaExtensionModelLoader().loadExtensionModel(annotatedClass.getClassLoader(), params);
        this.extensionManager.registerExtension(model);
        return model;
    }

    public List<GeneratedResource> generateLoaderResources(ExtensionModel extensionModel, File generatedResourcesDirectory) {
        this.createManifestFileIfNecessary(generatedResourcesDirectory);
        ExtensionsTestLoaderResourcesGenerator generator = new ExtensionsTestLoaderResourcesGenerator(this.getResourceFactories(), generatedResourcesDirectory);
        generator.generateFor(extensionModel);
        return generator.dumpAll();
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory) {
        return this.generateDslResources(generatedResourcesDirectory, null);
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory, ExtensionModel forExtensionModel) {
        NullDslResolvingContext context = this.extensionManager.getExtensions().stream().anyMatch(e -> !e.getImportedTypes().isEmpty()) ? DslResolvingContext.getDefault((Set)this.extensionManager.getExtensions()) : new NullDslResolvingContext();
        ExtensionsTestDslResourcesGenerator dslResourceGenerator = new ExtensionsTestDslResourcesGenerator(this.getDslResourceFactories(), generatedResourcesDirectory, (DslResolvingContext)context);
        this.extensionManager.getExtensions().stream().filter(runtimeExtensionModel -> forExtensionModel != null ? runtimeExtensionModel.equals(forExtensionModel) : true).forEach(dslResourceGenerator::generateFor);
        return dslResourceGenerator.dumpAll();
    }

    private List<GeneratedResourceFactory> getResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(GeneratedResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private List<DslResourceFactory> getDslResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(DslResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private File createManifestFileIfNecessary(File targetDirectory) {
        return this.createManifestFileIfNecessary(targetDirectory, MuleManifest.getManifest());
    }

    private File createManifestFileIfNecessary(File targetDirectory, Manifest sourceManifest) {
        try {
            File manifestFile = new File(targetDirectory.getPath(), "MANIFEST.MF");
            if (!manifestFile.exists()) {
                Manifest manifest = new Manifest(sourceManifest);
                try (FileOutputStream fileOutputStream = new FileOutputStream(manifestFile);){
                    manifest.write(fileOutputStream);
                }
            }
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating discoverer", e);
        }
    }
}

