/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;

public class TestContainerModuleDiscoverer
implements ModuleDiscoverer {
    private final Set<String> privilegedArtifactIds;
    private ModuleDiscoverer delegateModuleDiscoverer;

    public TestContainerModuleDiscoverer(Set<String> privilegedArtifactIds) {
        Preconditions.checkArgument((privilegedArtifactIds != null ? 1 : 0) != 0, (String)"privilegedArtifactIds cannot be null");
        this.privilegedArtifactIds = privilegedArtifactIds;
        this.delegateModuleDiscoverer = new ContainerModuleDiscoverer(this.getClass().getClassLoader());
    }

    public TestContainerModuleDiscoverer(Set<String> privilegedArtifactIds, ModuleDiscoverer moduleDiscoverer) {
        Preconditions.checkArgument((privilegedArtifactIds != null ? 1 : 0) != 0, (String)"privilegedArtifactIds cannot be null");
        Preconditions.checkArgument((moduleDiscoverer != null ? 1 : 0) != 0, (String)"moduleDiscoverer cannot be null");
        this.privilegedArtifactIds = privilegedArtifactIds;
        this.delegateModuleDiscoverer = moduleDiscoverer;
    }

    public List<MuleModule> discover() {
        DefaultModuleRepository containerModuleDiscoverer = new DefaultModuleRepository(this.delegateModuleDiscoverer);
        List discoveredModules = containerModuleDiscoverer.getModules();
        ArrayList<MuleModule> updateModules = new ArrayList<MuleModule>(discoveredModules.size());
        for (MuleModule discoveredModule : discoveredModules) {
            if (!discoveredModule.getPrivilegedExportedPackages().isEmpty()) {
                discoveredModule = this.updateModuleForTests(discoveredModule);
            }
            updateModules.add(discoveredModule);
        }
        return updateModules;
    }

    private MuleModule updateModuleForTests(MuleModule discoveredModule) {
        HashSet<String> privilegedArtifacts = new HashSet<String>(discoveredModule.getPrivilegedArtifacts());
        privilegedArtifacts.addAll(this.privilegedArtifactIds);
        return new MuleModule(discoveredModule.getName(), discoveredModule.getExportedPackages(), discoveredModule.getExportedPaths(), discoveredModule.getPrivilegedExportedPackages(), privilegedArtifacts, discoveredModule.getExportedServices());
    }
}

