/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.test.runner.api.ArtifactClassificationNode;
import org.mule.test.runner.api.ArtifactClassificationType;
import org.mule.test.runner.api.ArtifactClassificationTypeResolver;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.ClassPathClassifier;
import org.mule.test.runner.api.ClassPathClassifierContext;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.ExtensionPluginMetadataGenerator;
import org.mule.test.runner.api.PluginResourcesResolver;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.classification.PatternExclusionsDependencyFilter;
import org.mule.test.runner.classification.PatternInclusionsDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherClassPathClassifier
implements ClassPathClassifier {
    private static final String POM = "pom";
    private static final String POM_XML = "pom.xml";
    private static final String POM_EXTENSION = ".pom";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String MAVEN_COORDINATES_SEPARATOR = ":";
    private static final String JAR_EXTENSION = "jar";
    private static final String SNAPSHOT_WILCARD_FILE_FILTER = "*-SNAPSHOT*.*";
    private static final String TESTS_CLASSIFIER = "tests";
    private static final String TESTS_JAR = "-tests.jar";
    private static final String SERVICE_PROPERTIES_FILE_NAME = "service.properties";
    private static final String SERVICE_PROVIDER_CLASS_NAME = "service.className";
    private static final String MULE_SERVICE_CLASSIFIER = "mule-service";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DependencyResolver dependencyResolver;
    private ArtifactClassificationTypeResolver artifactClassificationTypeResolver;
    private PluginResourcesResolver pluginResourcesResolver = new PluginResourcesResolver();

    public AetherClassPathClassifier(DependencyResolver dependencyResolver, ArtifactClassificationTypeResolver artifactClassificationTypeResolver) {
        Preconditions.checkNotNull((Object)dependencyResolver, (String)"dependencyResolver cannot be null");
        Preconditions.checkNotNull((Object)artifactClassificationTypeResolver, (String)"artifactClassificationTypeResolver cannot be null");
        this.dependencyResolver = dependencyResolver;
        this.artifactClassificationTypeResolver = artifactClassificationTypeResolver;
    }

    @Override
    public ArtifactsUrlClassification classify(ClassPathClassifierContext context) {
        List<Dependency> directDependencies;
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        this.logger.debug("Building class loaders for rootArtifact: {}", (Object)context.getRootArtifact());
        try {
            directDependencies = this.dependencyResolver.getDirectDependencies(context.getRootArtifact());
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't get direct dependencies for rootArtifact: '" + context.getRootArtifact() + "'", e);
        }
        ArtifactClassificationType rootArtifactType = this.artifactClassificationTypeResolver.resolveArtifactClassificationType(context.getRootArtifact());
        if (rootArtifactType == null) {
            throw new IllegalStateException("Couldn't be identified type for rootArtifact: " + context.getRootArtifact());
        }
        this.logger.debug("rootArtifact {} identified as {} type", (Object)context.getRootArtifact(), (Object)rootArtifactType);
        List remoteRepositories = null;
        try {
            remoteRepositories = this.dependencyResolver.readArtifactDescriptor(context.getRootArtifact()).getRepositories();
        }
        catch (ArtifactDescriptorException e) {
            throw new IllegalStateException("Couldn't read rootArtifact descriptor", e);
        }
        List<URL> pluginSharedLibUrls = this.buildPluginSharedLibClassification(context, directDependencies, remoteRepositories);
        List<PluginUrlClassification> pluginUrlClassifications = this.buildPluginUrlClassifications(context, directDependencies, rootArtifactType, remoteRepositories);
        List<ArtifactUrlClassification> serviceUrlClassifications = this.buildServicesUrlClassification(context, directDependencies, remoteRepositories);
        List<URL> containerUrls = this.buildContainerUrlClassification(context, directDependencies, serviceUrlClassifications, pluginUrlClassifications, rootArtifactType, remoteRepositories);
        List<URL> applicationUrls = this.buildApplicationUrlClassification(context, directDependencies, rootArtifactType, remoteRepositories);
        return new ArtifactsUrlClassification(containerUrls, serviceUrlClassifications, pluginSharedLibUrls, pluginUrlClassifications, applicationUrls);
    }

    private List<ArtifactUrlClassification> buildServicesUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<RemoteRepository> rootArtifactRemoteRepositories) {
        LinkedHashMap servicesClassified = Maps.newLinkedHashMap();
        Predicate<Dependency> muleServiceClassifiedDependencyFilter = dependency -> dependency.getArtifact().getClassifier().equals(MULE_SERVICE_CLASSIFIER);
        List<Artifact> serviceArtifactsDeclared = this.filterArtifacts(directDependencies, muleServiceClassifiedDependencyFilter);
        this.logger.debug("{} services defined to be classified", (Object)serviceArtifactsDeclared.size());
        serviceArtifactsDeclared.stream().forEach(serviceArtifact -> this.buildPluginUrlClassification((Artifact)serviceArtifact, context, muleServiceClassifiedDependencyFilter, servicesClassified, rootArtifactRemoteRepositories));
        return this.toServiceUrlClassification(servicesClassified.values());
    }

    private List<URL> buildPluginSharedLibClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ArrayList pluginSharedLibUrls = Lists.newArrayList();
        List pluginSharedLibDependencies = context.getSharedPluginLibCoordinates().stream().map(sharedPluginLibCoords -> this.findPluginSharedLibArtifact((String)sharedPluginLibCoords, context.getRootArtifact(), directDependencies)).collect(Collectors.toList());
        this.logger.debug("Plugin sharedLib artifacts matched with versions from direct dependencies declared: {}", pluginSharedLibDependencies);
        pluginSharedLibDependencies.stream().map(pluginSharedLibDependency -> {
            try {
                return this.dependencyResolver.resolveArtifact(pluginSharedLibDependency.getArtifact(), rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while resolving dependency '" + pluginSharedLibDependency + "' as plugin sharedLibs", e);
            }
        }).forEach(pluginSharedLibUrls::add);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(pluginSharedLibUrls, context.getClassPathURLs());
        this.logger.debug("Classified URLs as plugin runtime shared libraries: '{}", (Object)pluginSharedLibUrls);
        return pluginSharedLibUrls;
    }

    private List<URL> buildContainerUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, List<ArtifactUrlClassification> serviceUrlClassifications, List<PluginUrlClassification> pluginUrlClassifications, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        List<URL> containerUrls;
        directDependencies = directDependencies.stream().filter(this.getContainerDirectDependenciesFilter(rootArtifactType)).filter(dependency -> {
            Artifact artifact = dependency.getArtifact();
            return !serviceUrlClassifications.stream().filter(artifactUrlClassification -> artifactUrlClassification.getArtifactId().equals(ArtifactIdUtils.toId((Artifact)artifact))).findAny().isPresent() && !pluginUrlClassifications.stream().filter(artifactUrlClassification -> artifactUrlClassification.getArtifactId().equals(ArtifactIdUtils.toId((Artifact)artifact))).findAny().isPresent();
        }).map(depToTransform -> depToTransform.setScope("compile")).collect(Collectors.toList());
        this.logger.debug("Selected direct dependencies to be used for resolving container dependency graph (changed to compile in order to resolve the graph): {}", directDependencies);
        Set<Dependency> managedDependencies = this.selectContainerManagedDependencies(context, directDependencies, rootArtifactType, rootArtifactRemoteRepositories);
        this.logger.debug("Collected managed dependencies from direct provided dependencies to be used for resolving container dependency graph: {}", managedDependencies);
        ArrayList excludedFilterPattern = Lists.newArrayList(context.getProvidedExclusions());
        excludedFilterPattern.addAll(context.getExcludedArtifacts());
        if (!pluginUrlClassifications.isEmpty()) {
            excludedFilterPattern.addAll(pluginUrlClassifications.stream().map(pluginUrlClassification -> pluginUrlClassification.getArtifactId()).collect(Collectors.toList()));
        }
        if (!serviceUrlClassifications.isEmpty()) {
            excludedFilterPattern.addAll(serviceUrlClassifications.stream().map(serviceUrlClassification -> serviceUrlClassification.getArtifactId()).collect(Collectors.toList()));
        }
        this.logger.debug("Resolving dependencies for container using exclusion filter patterns: {}", (Object)excludedFilterPattern);
        PatternExclusionsDependencyFilter dependencyFilter = new PatternExclusionsDependencyFilter(excludedFilterPattern);
        try {
            containerUrls = this.toUrl(this.dependencyResolver.resolveDependencies(null, directDependencies, Lists.newArrayList(managedDependencies), dependencyFilter, rootArtifactRemoteRepositories));
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for Container", e);
        }
        containerUrls = containerUrls.stream().filter(url -> {
            String file = FileUtils.toFile((URL)url).getAbsolutePath();
            return !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_XML) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)POM_EXTENSION) && !StringUtils.endsWithIgnoreCase((CharSequence)file, (CharSequence)ZIP_EXTENSION);
        }).collect(Collectors.toList());
        if (ArtifactClassificationType.MODULE.equals((Object)rootArtifactType)) {
            File rootArtifactOutputFile = this.resolveRootArtifactFile(context.getRootArtifact());
            if (rootArtifactOutputFile == null) {
                throw new IllegalStateException("rootArtifact (" + context.getRootArtifact() + ") identified as MODULE but doesn't have an output");
            }
            containerUrls.add(0, this.toUrl(rootArtifactOutputFile));
        }
        this.resolveSnapshotVersionsToTimestampedFromClassPath(containerUrls, context.getClassPathURLs());
        return containerUrls;
    }

    private Set<Dependency> selectContainerManagedDependencies(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        Set<Object> managedDependencies;
        if (!rootArtifactType.equals((Object)ArtifactClassificationType.MODULE)) {
            managedDependencies = directDependencies.stream().map(directDep -> {
                try {
                    return this.dependencyResolver.readArtifactDescriptor(directDep.getArtifact(), rootArtifactRemoteRepositories).getManagedDependencies();
                }
                catch (ArtifactDescriptorException e) {
                    throw new IllegalStateException("Couldn't read artifact: '" + directDep.getArtifact() + "' while collecting managed dependencies for Container", e);
                }
            }).flatMap(l -> l.stream()).collect(Collectors.toSet());
        } else {
            try {
                managedDependencies = Sets.newHashSet((Iterable)this.dependencyResolver.readArtifactDescriptor(context.getRootArtifact()).getManagedDependencies());
            }
            catch (ArtifactDescriptorException e) {
                throw new IllegalStateException("Couldn't collect managed dependencies for rootArtifact (" + context.getRootArtifact() + ")", e);
            }
        }
        return managedDependencies;
    }

    private Predicate<Dependency> getContainerDirectDependenciesFilter(ArtifactClassificationType rootArtifactType) {
        return rootArtifactType.equals((Object)ArtifactClassificationType.MODULE) ? directDep -> directDep.getScope().equals("provided") || directDep.getScope().equals("compile") : directDep -> directDep.getScope().equals("provided") || directDep.getArtifact().getClassifier().equals("mule-plugin");
    }

    private List<PluginUrlClassification> buildPluginUrlClassifications(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        LinkedHashMap pluginsClassified = Maps.newLinkedHashMap();
        Artifact rootArtifact = context.getRootArtifact();
        List pluginsArtifacts = directDependencies.stream().filter(dependency -> dependency.getArtifact().getClassifier().equals("mule-plugin")).map(dependency -> dependency.getArtifact()).collect(Collectors.toList());
        this.logger.debug("{} plugins defined to be classified", (Object)pluginsArtifacts.size());
        Predicate<Dependency> mulePluginDependencyFilter = dependency -> dependency.getArtifact().getClassifier().equals("mule-plugin");
        if (ArtifactClassificationType.PLUGIN.equals((Object)rootArtifactType)) {
            this.logger.debug("rootArtifact '{}' identified as Mule plugin", (Object)rootArtifact);
            this.buildPluginUrlClassification(rootArtifact, context, mulePluginDependencyFilter, pluginsClassified, rootArtifactRemoteRepositories);
            pluginsArtifacts = pluginsArtifacts.stream().filter(pluginArtifact -> !rootArtifact.getGroupId().equals(pluginArtifact.getGroupId()) || !rootArtifact.getArtifactId().equals(pluginArtifact.getArtifactId())).collect(Collectors.toList());
        }
        pluginsArtifacts.stream().forEach(pluginArtifact -> this.buildPluginUrlClassification((Artifact)pluginArtifact, context, mulePluginDependencyFilter, pluginsClassified, rootArtifactRemoteRepositories));
        if (context.isExtensionMetadataGenerationEnabled()) {
            ExtensionPluginMetadataGenerator extensionPluginMetadataGenerator = new ExtensionPluginMetadataGenerator(context.getPluginResourcesFolder());
            for (ArtifactClassificationNode pluginClassifiedNode : pluginsClassified.values()) {
                List<URL> urls = this.generateExtensionMetadata(pluginClassifiedNode.getArtifact(), context, extensionPluginMetadataGenerator, pluginClassifiedNode.getUrls(), rootArtifactRemoteRepositories);
                pluginClassifiedNode.setUrls(urls);
            }
            extensionPluginMetadataGenerator.generateDslResources();
        }
        return this.toPluginUrlClassification(pluginsClassified.values());
    }

    private List<ArtifactUrlClassification> toServiceUrlClassification(Collection<ArtifactClassificationNode> classificationNodes) {
        return classificationNodes.stream().map(node -> {
            InputStream servicePropertiesStream = new URLClassLoader(node.getUrls().toArray(new URL[0]), null).getResourceAsStream(SERVICE_PROPERTIES_FILE_NAME);
            Preconditions.checkNotNull((Object)servicePropertiesStream, (String)("Couldn't find service.properties for artifact: " + node.getArtifact()));
            try {
                Properties serviceProperties = PropertiesUtils.loadProperties((InputStream)servicePropertiesStream);
                String serviceProviderClassName = serviceProperties.getProperty(SERVICE_PROVIDER_CLASS_NAME);
                this.logger.debug("Discover serviceProviderClassName: {} for artifact: {}", (Object)serviceProviderClassName, (Object)node.getArtifact());
                if (node.getExportClasses() != null && !node.getExportClasses().isEmpty()) {
                    this.logger.warn("exportClasses is not supported for services artifacts, they are going to be ignored");
                }
                return new ArtifactUrlClassification(ArtifactIdUtils.toId((Artifact)node.getArtifact()), serviceProviderClassName, node.getUrls());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Couldn't read service.properties for artifact: " + node.getArtifact(), e);
            }
        }).collect(Collectors.toList());
    }

    private List<PluginUrlClassification> toPluginUrlClassification(Collection<ArtifactClassificationNode> classificationNodes) {
        LinkedHashMap classifiedPluginUrls = Maps.newLinkedHashMap();
        for (ArtifactClassificationNode node : classificationNodes) {
            List<String> pluginDependencies = node.getArtifactDependencies().stream().map(dependency -> ArtifactIdUtils.toId((Artifact)dependency.getArtifact())).collect(Collectors.toList());
            String classifierLessId = ArtifactIdUtils.toId((Artifact)node.getArtifact());
            PluginUrlClassification pluginUrlClassification = this.pluginResourcesResolver.resolvePluginResourcesFor(new PluginUrlClassification(classifierLessId, node.getUrls(), node.getExportClasses(), pluginDependencies));
            classifiedPluginUrls.put(classifierLessId, pluginUrlClassification);
        }
        for (PluginUrlClassification pluginUrlClassification : classifiedPluginUrls.values()) {
            for (String dependency2 : pluginUrlClassification.getPluginDependencies()) {
                PluginUrlClassification dependencyPlugin = (PluginUrlClassification)classifiedPluginUrls.get(dependency2);
                if (dependencyPlugin == null) {
                    throw new IllegalStateException("Unable to find a plugin dependency: " + dependency2);
                }
                pluginUrlClassification.getExportedPackages().removeAll(dependencyPlugin.getExportedPackages());
            }
        }
        return Lists.newArrayList(classifiedPluginUrls.values());
    }

    private void buildPluginUrlClassification(Artifact artifactToClassify, ClassPathClassifierContext context, Predicate<Dependency> directDependenciesFilter, Map<String, ArtifactClassificationNode> artifactsClassified, List<RemoteRepository> rootArtifactRemoteRepositories) {
        List<Dependency> directDependencies;
        List<URL> urls;
        try {
            DependencyFilter dependencyFilter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}), new PatternExclusionsDependencyFilter(context.getExcludedArtifacts()), DependencyFilterUtils.orFilter((DependencyFilter[])new DependencyFilter[]{new PatternExclusionsDependencyFilter("*:*:*:mule-plugin:*"), new PatternInclusionsDependencyFilter(ArtifactIdUtils.toId((Artifact)artifactToClassify))})});
            urls = this.toUrl(this.dependencyResolver.resolveDependencies(new Dependency(artifactToClassify, "compile"), Collections.emptyList(), Collections.emptyList(), dependencyFilter, rootArtifactRemoteRepositories));
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for artifact: '" + artifactToClassify + "' classification", e);
        }
        ArrayList artifactDependencies = Lists.newArrayList();
        try {
            directDependencies = this.dependencyResolver.getDirectDependencies(artifactToClassify, rootArtifactRemoteRepositories);
        }
        catch (ArtifactDescriptorException e) {
            throw new IllegalStateException("Couldn't get direct dependencies for artifact: '" + artifactToClassify + "'", e);
        }
        this.logger.debug("Searching for dependencies on direct dependencies of artifact {}", (Object)artifactToClassify);
        List<Artifact> pluginArtifactDependencies = this.filterArtifacts(directDependencies, directDependenciesFilter);
        this.logger.debug("Artifacts {} identified a plugin dependencies for plugin {}", pluginArtifactDependencies, (Object)artifactToClassify);
        pluginArtifactDependencies.stream().map(artifact -> {
            String artifactClassifierLessId = ArtifactIdUtils.toId((Artifact)artifact);
            if (!artifactsClassified.containsKey(artifactClassifierLessId)) {
                this.buildPluginUrlClassification((Artifact)artifact, context, directDependenciesFilter, artifactsClassified, rootArtifactRemoteRepositories);
            }
            return (ArtifactClassificationNode)artifactsClassified.get(artifactClassifierLessId);
        }).forEach(artifactDependencies::add);
        List<Class> exportClasses = this.getArtifactExportedClasses(artifactToClassify, context, rootArtifactRemoteRepositories);
        this.resolveSnapshotVersionsToTimestampedFromClassPath(urls, context.getClassPathURLs());
        ArtifactClassificationNode artifactUrlClassification = new ArtifactClassificationNode(artifactToClassify, urls, exportClasses, artifactDependencies);
        artifactsClassified.put(ArtifactIdUtils.toId((Artifact)artifactToClassify), artifactUrlClassification);
    }

    private List<Class> getArtifactExportedClasses(Artifact exporterArtifact, ClassPathClassifierContext context, List<RemoteRepository> rootArtifactRemoteRepositories) {
        AtomicReference<URL> artifactUrl = new AtomicReference<URL>();
        try {
            artifactUrl.set(this.dependencyResolver.resolveArtifact(exporterArtifact, rootArtifactRemoteRepositories).getArtifact().getFile().toURI().toURL());
        }
        catch (MalformedURLException | ArtifactResolutionException e) {
            throw new IllegalStateException("Unable to resolve artifact URL", e);
        }
        Artifact rootArtifact = context.getRootArtifact();
        return context.getExportPluginClasses().stream().filter(clazz -> {
            boolean isFromCurrentArtifact = clazz.getProtectionDomain().getCodeSource().getLocation().equals(artifactUrl.get());
            if (isFromCurrentArtifact && exporterArtifact != rootArtifact) {
                this.logger.warn("Exported class '{}' from plugin '{}' is being used from another artifact, {}", new Object[]{clazz.getSimpleName(), exporterArtifact, rootArtifact});
            }
            return isFromCurrentArtifact;
        }).collect(Collectors.toList());
    }

    private List<Artifact> filterArtifacts(List<Dependency> directDependencies, Predicate<Dependency> filter) {
        return directDependencies.stream().filter(dependency -> filter.test((Dependency)dependency)).map(dependency -> dependency.getArtifact()).collect(Collectors.toList());
    }

    private void checkPluginDeclaredAsDirectDependency(Artifact pluginArtifact, ClassPathClassifierContext context, List<Dependency> rootArtifactDirectDependencies) {
        if (!context.getRootArtifact().equals(pluginArtifact) && !this.findDirectDependency(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), rootArtifactDirectDependencies).isPresent()) {
            throw new IllegalStateException("Plugin '" + pluginArtifact + "' has to be defined as direct dependency of your Maven project (" + context.getRootArtifact() + ")");
        }
    }

    private List<URL> generateExtensionMetadata(Artifact plugin, ClassPathClassifierContext context, ExtensionPluginMetadataGenerator pluginGenerator, List<URL> urls, List<RemoteRepository> rootArtifactRemoteRepositories) {
        Class extensionClass = pluginGenerator.scanForExtensionAnnotatedClasses(plugin, urls);
        if (extensionClass != null) {
            this.logger.debug("Plugin '{}' has been discovered as Extension", (Object)plugin);
            if (context.isExtensionMetadataGenerationEnabled()) {
                File generatedMetadataFolder = pluginGenerator.generateExtensionResources(plugin, extensionClass, this.dependencyResolver, rootArtifactRemoteRepositories);
                URL generatedTestResources = this.toUrl(generatedMetadataFolder);
                ArrayList appendedTestResources = Lists.newArrayList((Object[])new URL[]{generatedTestResources});
                appendedTestResources.addAll(urls);
                urls = appendedTestResources;
            }
        }
        return urls;
    }

    private Optional<Dependency> findDirectDependency(String groupId, String artifactId, List<Dependency> directDependencies) {
        return directDependencies.isEmpty() ? Optional.empty() : directDependencies.stream().filter(dependency -> dependency.getArtifact().getGroupId().equals(groupId) && dependency.getArtifact().getArtifactId().equals(artifactId)).findFirst();
    }

    private Dependency findPluginSharedLibArtifact(String pluginSharedLibCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        Optional<Dependency> pluginSharedLibDependency = this.discoverDependency(pluginSharedLibCoords, rootArtifact, directDependencies);
        if (!pluginSharedLibDependency.isPresent()) {
            throw new IllegalStateException("Plugin shared lib artifact '" + pluginSharedLibCoords + "' in order to be resolved has to be declared as " + "test" + " dependency of your Maven project (" + rootArtifact + ")");
        }
        return pluginSharedLibDependency.get();
    }

    public Optional<Dependency> discoverDependency(String artifactCoords, Artifact rootArtifact, List<Dependency> directDependencies) {
        String[] artifactCoordsSplit = artifactCoords.split(MAVEN_COORDINATES_SEPARATOR);
        if (artifactCoordsSplit.length != 2) {
            throw new IllegalArgumentException("Artifact coordinates should be in format of groupId:artifactId, '" + artifactCoords + "' is not a valid format");
        }
        String groupId = artifactCoordsSplit[0];
        String artifactId = artifactCoordsSplit[1];
        if (rootArtifact.getGroupId().equals(groupId) && rootArtifact.getArtifactId().equals(artifactId)) {
            this.logger.debug("'{}' artifact coordinates matched with rootArtifact '{}', resolving version from rootArtifact", (Object)artifactCoords, (Object)rootArtifact);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, JAR_EXTENSION, rootArtifact.getVersion());
            this.logger.debug("'{}' artifact coordinates resolved to: '{}'", (Object)artifactCoords, (Object)artifact);
            return Optional.of(new Dependency((Artifact)artifact, "compile"));
        }
        this.logger.debug("Resolving version for '{}' from direct dependencies", (Object)artifactCoords);
        return this.findDirectDependency(groupId, artifactId, directDependencies);
    }

    private List<URL> buildApplicationUrlClassification(ClassPathClassifierContext context, List<Dependency> directDependencies, ArtifactClassificationType rootArtifactType, List<RemoteRepository> rootArtifactRemoteRepositories) {
        this.logger.debug("Building application classification");
        Artifact rootArtifact = context.getRootArtifact();
        PatternInclusionsDependencyFilter dependencyFilter = new PatternInclusionsDependencyFilter(context.getTestInclusions());
        this.logger.debug("Using filter for dependency graph to include: '{}'", context.getTestInclusions());
        ArrayList appFiles = Lists.newArrayList();
        ArrayList exclusionsPatterns = Lists.newArrayList();
        if (ArtifactClassificationType.APPLICATION.equals((Object)rootArtifactType)) {
            this.logger.debug("RootArtifact identified as {} so is going to be added to application classification", (Object)ArtifactClassificationType.APPLICATION);
            File rootArtifactOutputFile = this.resolveRootArtifactFile(rootArtifact);
            if (rootArtifactOutputFile != null) {
                appFiles.add(rootArtifactOutputFile);
            } else {
                this.logger.warn("rootArtifact '{}' identified as {} but doesn't have an output {} file", new Object[]{rootArtifact, rootArtifactType, JAR_EXTENSION});
            }
        } else {
            this.logger.debug("RootArtifact already classified as plugin or module, excluding it from application classification");
            exclusionsPatterns.add(rootArtifact.getGroupId() + MAVEN_COORDINATES_SEPARATOR + rootArtifact.getArtifactId() + MAVEN_COORDINATES_SEPARATOR + "*" + MAVEN_COORDINATES_SEPARATOR + "*" + MAVEN_COORDINATES_SEPARATOR + rootArtifact.getVersion());
        }
        directDependencies = directDependencies.stream().map(toTransform -> {
            if (toTransform.getScope().equals("test")) {
                return toTransform.setScope("compile");
            }
            if (ArtifactClassificationType.PLUGIN.equals((Object)rootArtifactType) && toTransform.getScope().equals("compile")) {
                return toTransform.setScope("provided");
            }
            Artifact artifact = toTransform.getArtifact();
            if (context.getSharedPluginLibCoordinates().contains(artifact.getGroupId() + MAVEN_COORDINATES_SEPARATOR + artifact.getArtifactId())) {
                return toTransform.setScope("compile");
            }
            return toTransform;
        }).collect(Collectors.toList());
        this.logger.debug("OR exclude: {}", context.getExcludedArtifacts());
        exclusionsPatterns.addAll(context.getExcludedArtifacts());
        if (!context.getTestExclusions().isEmpty()) {
            this.logger.debug("OR exclude application specific artifacts: {}", context.getTestExclusions());
            exclusionsPatterns.addAll(context.getTestExclusions());
        }
        try {
            ArrayList managedDependencies = Lists.newArrayList((Iterable)this.dependencyResolver.readArtifactDescriptor(rootArtifact).getManagedDependencies());
            managedDependencies.addAll(directDependencies.stream().filter(directDependency -> !directDependency.getScope().equals("test")).collect(Collectors.toList()));
            this.logger.debug("Resolving dependency graph for '{}' scope direct dependencies: {} and managed dependencies {}", new Object[]{"test", directDependencies, managedDependencies});
            Dependency rootTestDependency = new Dependency((Artifact)new DefaultArtifact(rootArtifact.getGroupId(), rootArtifact.getArtifactId(), TESTS_CLASSIFIER, JAR_EXTENSION, rootArtifact.getVersion()), "test");
            List<File> urls = this.dependencyResolver.resolveDependencies(rootTestDependency, directDependencies, managedDependencies, DependencyFilterUtils.orFilter((DependencyFilter[])new DependencyFilter[]{dependencyFilter, new PatternExclusionsDependencyFilter(exclusionsPatterns)}), rootArtifactRemoteRepositories);
            appFiles.addAll(urls);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't resolve dependencies for application '" + context.getRootArtifact() + "' classification", e);
        }
        ArrayList appUrls = Lists.newArrayList(this.toUrl(appFiles));
        this.logger.debug("Appending URLs to application: {}", context.getApplicationUrls());
        appUrls.addAll(context.getApplicationUrls());
        this.resolveSnapshotVersionsToTimestampedFromClassPath(appUrls, context.getClassPathURLs());
        return appUrls;
    }

    private File resolveRootArtifactFile(Artifact rootArtifact) {
        DefaultArtifact jarArtifact = new DefaultArtifact(rootArtifact.getGroupId(), rootArtifact.getArtifactId(), JAR_EXTENSION, JAR_EXTENSION, rootArtifact.getVersion());
        try {
            return this.dependencyResolver.resolveArtifact((Artifact)jarArtifact).getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            this.logger.warn("'{}' rootArtifact output {} file couldn't be resolved", (Object)rootArtifact, (Object)JAR_EXTENSION);
            return null;
        }
    }

    private List<URL> toUrl(Collection<File> files) {
        return files.stream().map(this::toUrl).collect(Collectors.toList());
    }

    private URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't get URL", e);
        }
    }

    private void resolveSnapshotVersionsToTimestampedFromClassPath(List<URL> resolvedURLs, List<URL> classpathURLs) {
        this.logger.debug("Checking if resolved SNAPSHOT URLs had a timestamped version already included in class path URLs");
        Map<File, List<URL>> classpathFolders = this.groupArtifactUrlsByFolder(classpathURLs);
        WildcardFileFilter snapshotFileFilter = new WildcardFileFilter(SNAPSHOT_WILCARD_FILE_FILTER);
        ListIterator<URL> listIterator = resolvedURLs.listIterator();
        while (listIterator.hasNext()) {
            URL urlResolved = listIterator.next();
            File artifactResolvedFile = FileUtils.toFile((URL)urlResolved);
            if (!snapshotFileFilter.accept(artifactResolvedFile)) continue;
            File artifactResolvedFileParentFile = artifactResolvedFile.getParentFile();
            this.logger.debug("Checking if resolved SNAPSHOT artifact: '{}' has a timestamped version already in class path", (Object)artifactResolvedFile);
            URL urlFromClassPath = null;
            if (classpathFolders.containsKey(artifactResolvedFileParentFile)) {
                urlFromClassPath = this.findArtifactUrlFromClassPath(classpathFolders, artifactResolvedFile);
            }
            if (urlFromClassPath != null) {
                this.logger.debug("Replacing resolved URL '{}' from class path URL '{}'", (Object)urlResolved, (Object)urlFromClassPath);
                listIterator.set(urlFromClassPath);
                continue;
            }
            this.logger.warn("'{}' resolved SNAPSHOT version couldn't be matched to a class path URL: '{}'", (Object)artifactResolvedFile, classpathURLs);
        }
    }

    private Map<File, List<URL>> groupArtifactUrlsByFolder(List<URL> classpathURLs) {
        HashMap classpathFolders = Maps.newHashMap();
        classpathURLs.forEach(url -> {
            File folder = FileUtils.toFile((URL)url).getParentFile();
            if (classpathFolders.containsKey(folder)) {
                ((List)classpathFolders.get(folder)).add(url);
            } else {
                classpathFolders.put(folder, Lists.newArrayList((Object[])new URL[]{url}));
            }
        });
        return classpathFolders;
    }

    private URL findArtifactUrlFromClassPath(Map<File, List<URL>> classpathFolders, File artifactResolvedFile) {
        List<URL> urls = classpathFolders.get(artifactResolvedFile.getParentFile());
        this.logger.debug("URLs found for '{}' in class path are: {}", (Object)artifactResolvedFile, urls);
        if (urls.size() == 1) {
            return urls.get(0);
        }
        Optional<URL> urlOpt = StringUtils.endsWithIgnoreCase((CharSequence)artifactResolvedFile.getName(), (CharSequence)TESTS_JAR) ? urls.stream().filter(url -> FileUtils.toFile((URL)url).getAbsolutePath().endsWith(TESTS_JAR)).findFirst() : urls.stream().filter(url -> {
            String filePath = FileUtils.toFile((URL)url).getAbsolutePath();
            return !filePath.endsWith(TESTS_JAR) && filePath.endsWith(JAR_EXTENSION);
        }).findFirst();
        return urlOpt.orElse(null);
    }
}

