/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.AbstractResourcesGenerator;

class ExtensionsTestLoaderResourcesGenerator
extends AbstractResourcesGenerator {
    private final File targetDirectory;
    private final Map<String, StringBuilder> contents = new HashMap<String, StringBuilder>();

    ExtensionsTestLoaderResourcesGenerator(Collection<GeneratedResourceFactory> resourceFactories, File targetDirectory) {
        super(resourceFactories);
        this.targetDirectory = targetDirectory;
    }

    protected void write(GeneratedResource resource) {
        String resourceKey = Paths.get(this.targetDirectory.getPath(), resource.getPath()).toString();
        StringBuilder builder = this.contents.get(resourceKey);
        if (builder == null) {
            builder = new StringBuilder();
            this.contents.put(resourceKey, builder);
        }
        if (builder.length() > 0) {
            builder.append("\n");
        }
        builder.append(new String(resource.getContent()));
    }

    List<GeneratedResource> dumpAll() {
        List allResources = (List)this.contents.entrySet().stream().map(entry -> new GeneratedResource((String)entry.getKey(), ((StringBuilder)entry.getValue()).toString().getBytes())).collect(Collectors.toImmutableList());
        allResources.forEach(resource -> {
            File targetFile = new File(resource.getPath());
            try {
                FileUtils.stringToFile((String)targetFile.getAbsolutePath(), (String)new String(resource.getContent()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return allResources;
    }
}

