/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.maven;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.test.runner.api.WorkspaceLocationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDiscoverWorkspaceLocationResolver
implements WorkspaceLocationResolver {
    public static final String POM_XML_FILE = "pom.xml";
    public static final String MAVEN_MULTI_MODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, File> filePathByArtifactId = new HashMap<String, File>();

    public AutoDiscoverWorkspaceLocationResolver(List<URL> classPath, File rootArtifactClassesFolder) {
        String rootProjectDirectoryProperty;
        Preconditions.checkNotNull(classPath, (String)"classPath cannot be null");
        Preconditions.checkNotNull((Object)rootArtifactClassesFolder, (String)"rootArtifactClassesFolder cannot be null");
        File rootArtifactFolder = rootArtifactClassesFolder.getParentFile().getParentFile();
        this.logger.debug("Discovering workspace artifacts locations from '{}'", (Object)rootArtifactFolder);
        if (!this.containsMavenProject(rootArtifactFolder)) {
            this.logger.warn("Couldn't find any workspace reference for artifacts due to '{}' is not a Maven project", (Object)rootArtifactFolder);
        }
        if (StringUtils.isNotBlank((CharSequence)(rootProjectDirectoryProperty = System.getProperty(MAVEN_MULTI_MODULE_PROJECT_DIRECTORY)))) {
            this.logger.debug("Using Maven System.property['{}']='{}' to find out project root directory for discovering poms", (Object)MAVEN_MULTI_MODULE_PROJECT_DIRECTORY, (Object)rootProjectDirectoryProperty);
            this.discoverMavenReactorProjects(rootProjectDirectoryProperty, classPath, rootArtifactClassesFolder.getParentFile().getParentFile());
        } else {
            this.logger.debug("Filtering class path entries to find out Maven projects");
            this.discoverMavenProjectsFromClassPath(classPath);
        }
        this.logger.debug("Workspace location discover process completed");
        ArrayList messages = Lists.newArrayList((Object[])new String[]{"Workspace:"});
        messages.add(" ");
        messages.addAll(this.filePathByArtifactId.entrySet().stream().map(entry -> (String)entry.getKey() + " -> (" + entry.getValue() + ")").collect(Collectors.toList()));
        this.logger.debug(StringMessageUtils.getBoilerPlate((List)Lists.newArrayList((Iterable)messages), (char)'*', (int)150));
    }

    private void discoverMavenReactorProjects(String rootProjectDirectoryProperty, List<URL> classPath, File rootArtifactClassesFolder) {
        File currentDir;
        Path rootProjectDirectory = Paths.get(rootProjectDirectoryProperty, new String[0]);
        this.logger.debug("Defined rootProjectDirectory='{}'", (Object)rootProjectDirectory);
        File lastMavenProjectDir = currentDir = rootArtifactClassesFolder;
        while (this.containsMavenProject(currentDir) && !currentDir.toPath().equals(rootProjectDirectory.getParent())) {
            lastMavenProjectDir = currentDir;
            currentDir = currentDir.getParentFile();
        }
        this.logger.debug("Top folder found, parent pom found at: '{}'", (Object)lastMavenProjectDir);
        try {
            Files.walkFileTree(lastMavenProjectDir.toPath(), new MavenDiscovererFileVisitor(classPath));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while discovering Maven projects from path: " + currentDir.toPath());
        }
    }

    private void discoverMavenProjectsFromClassPath(List<URL> classPath) {
        List classPaths = classPath.stream().map(url -> FileUtils.toFile((URL)url).toPath()).collect(Collectors.toList());
        List mavenProjects = classPaths.stream().filter(path -> this.containsMavenProject(path.getParent().getParent().toFile())).map(path -> path.getParent().getParent().toFile()).collect(Collectors.toList());
        this.logger.debug("Filtered from class path Maven projects: {}", mavenProjects);
        mavenProjects.stream().forEach(file -> this.resolvedArtifact(this.readMavenPomFile(this.getPomFile((File)file)).getArtifactId(), file.toPath()));
    }

    @Override
    public File resolvePath(String artifactId) {
        return this.filePathByArtifactId.get(artifactId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readMavenPomFile(File pomFile) {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (FileReader reader = new FileReader(pomFile);){
            Model model = mavenReader.read((Reader)reader);
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading Maven model from " + pomFile, e);
        }
    }

    private File getPomFile(File currentDir) {
        return new File(currentDir, POM_XML_FILE);
    }

    private boolean containsMavenProject(File dir) {
        return dir.isDirectory() && this.getPomFile(dir).exists();
    }

    private boolean isPomFile(File file) {
        return file.getName().equalsIgnoreCase(POM_XML_FILE);
    }

    private void resolvedArtifact(String artifactId, Path path) {
        this.logger.trace("Resolved artifactId from workspace at {}={}", (Object)artifactId, (Object)path);
        this.filePathByArtifactId.put(artifactId, path.toFile());
    }

    private class MavenDiscovererFileVisitor
    implements FileVisitor<Path> {
        private List<Path> classPath;

        public MavenDiscovererFileVisitor(List<URL> urlClassPath) {
            this.classPath = urlClassPath.stream().map(url -> FileUtils.toFile((URL)url).getParentFile().getParentFile().toPath()).collect(Collectors.toList());
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return AutoDiscoverWorkspaceLocationResolver.this.getPomFile(dir.toFile()).exists() ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (AutoDiscoverWorkspaceLocationResolver.this.isPomFile(file.toFile())) {
                Model model = AutoDiscoverWorkspaceLocationResolver.this.readMavenPomFile(file.toFile());
                Path location = file.getParent();
                AutoDiscoverWorkspaceLocationResolver.this.logger.debug("Checking if location {} is already present in class path", (Object)location);
                if (this.classPath.contains(location)) {
                    AutoDiscoverWorkspaceLocationResolver.this.resolvedArtifact(model.getArtifactId(), location);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

