/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.extension.privileged.spi.ExtensionsApiSpiUtils;
import org.mule.runtime.manifest.api.MuleManifest;
import org.mule.test.runner.infrastructure.ExtensionsTestDslResourcesGenerator;
import org.mule.test.runner.infrastructure.ExtensionsTestLoaderResourcesGenerator;

public class ExtensionsTestInfrastructureDiscoverer {
    private final ExtensionManager extensionManager;

    public ExtensionsTestInfrastructureDiscoverer(ExtensionManager extensionManagerAdapter) {
        this.extensionManager = extensionManagerAdapter;
    }

    public ExtensionModel discoverExtension(Class<?> annotatedClass, ExtensionModelLoader loader) {
        return this.discoverExtension(annotatedClass, loader, DslResolvingContext.getDefault(Collections.singleton(MuleExtensionModelProvider.getExtensionModel())));
    }

    public ExtensionModel discoverExtension(Class<?> annotatedClass, ExtensionModelLoader loader, DslResolvingContext dslResolvingContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", annotatedClass.getName());
        params.put("version", MuleManifest.getMuleManifest().getProductVersion());
        ExtensionModel model = loader.loadExtensionModel(annotatedClass.getClassLoader(), dslResolvingContext, params);
        this.extensionManager.registerExtension(model);
        return model;
    }

    public List<GeneratedResource> generateLoaderResources(ExtensionModel extensionModel, File generatedResourcesDirectory) {
        this.createManifestFileIfNecessary(generatedResourcesDirectory);
        ExtensionsTestLoaderResourcesGenerator generator = new ExtensionsTestLoaderResourcesGenerator(this.getResourceFactories(), generatedResourcesDirectory);
        generator.generateFor(extensionModel);
        return generator.dumpAll();
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory) {
        return this.generateDslResources(generatedResourcesDirectory, null);
    }

    public void generateSchemaTestResource(ExtensionModel model, File generatedResourcesDirectory) {
        String xsdFileName = model.getXmlDslModel().getXsdFileName();
        try {
            ExtensionSchemaGenerator schemaGenerator = this.getSchemaGenerator();
            HashSet<ExtensionModel> models = new HashSet<ExtensionModel>(this.extensionManager.getExtensions());
            models.add(MuleExtensionModelProvider.getExtensionModel());
            String schema = schemaGenerator.generate(model, DslResolvingContext.getDefault(models));
            File xsd = new File(generatedResourcesDirectory, xsdFileName);
            Files.writeString(xsd.toPath(), (CharSequence)schema, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error generating test xsd resource [%s]: " + e.getMessage(), xsdFileName, e));
        }
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory, ExtensionModel forExtensionModel) {
        DslResolvingContext context;
        if (this.extensionManager.getExtensions().stream().anyMatch(e -> !e.getImportedTypes().isEmpty())) {
            HashSet<ExtensionModel> models = new HashSet<ExtensionModel>(this.extensionManager.getExtensions());
            models.add(MuleExtensionModelProvider.getExtensionModel());
            context = DslResolvingContext.getDefault(models);
        } else {
            context = DslResolvingContext.nullDslResolvingContext();
        }
        ExtensionsTestDslResourcesGenerator dslResourceGenerator = new ExtensionsTestDslResourcesGenerator(this.getDslResourceFactories(), generatedResourcesDirectory, context);
        this.extensionManager.getExtensions().stream().filter(runtimeExtensionModel -> forExtensionModel != null ? runtimeExtensionModel.equals(forExtensionModel) : true).forEach(dslResourceGenerator::generateFor);
        return dslResourceGenerator.dumpAll();
    }

    private List<GeneratedResourceFactory> getResourceFactories() {
        return ExtensionsApiSpiUtils.loadGeneratedResourceFactories().collect(Collectors.toList());
    }

    private ExtensionSchemaGenerator getSchemaGenerator() {
        return (ExtensionSchemaGenerator)ExtensionsApiSpiUtils.loadExtensionSchemaGenerators().findFirst().get();
    }

    private List<DslResourceFactory> getDslResourceFactories() {
        return ExtensionsApiSpiUtils.loadDslResourceFactories().collect(Collectors.toList());
    }

    private File createManifestFileIfNecessary(File targetDirectory) {
        return this.createManifestFileIfNecessary(targetDirectory, MuleManifest.getMuleManifest().getManifest());
    }

    private File createManifestFileIfNecessary(File targetDirectory, Manifest sourceManifest) {
        try {
            File manifestFile = new File(targetDirectory.getPath(), "MANIFEST.MF");
            if (!manifestFile.exists()) {
                Manifest manifest = new Manifest(sourceManifest);
                try (FileOutputStream fileOutputStream = new FileOutputStream(manifestFile);){
                    manifest.write(fileOutputStream);
                }
            }
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating discoverer", e);
        }
    }
}

