/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.ClassPathClassifier;
import org.mule.test.runner.api.ClassPathClassifierContext;
import org.mule.test.runner.api.ClassPathUrlProvider;
import org.mule.test.runner.classloader.IsolatedClassLoaderFactory;
import org.mule.test.runner.maven.ArtifactFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactIsolatedClassLoaderBuilder {
    private static final String POM_XML = "pom.xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassPathClassifier classPathClassifier;
    private ClassPathUrlProvider classPathUrlProvider;
    private final IsolatedClassLoaderFactory isolatedClassLoaderFactory = new IsolatedClassLoaderFactory();
    private Artifact rootArtifact;
    private File pluginResourcesFolder;
    private Set<String> excludedArtifacts = Collections.emptySet();
    private Set<String> providedExclusions = Collections.emptySet();
    private Set<String> testExclusions = Collections.emptySet();
    private Set<String> testInclusions = Collections.emptySet();
    private Set<String> applicationSharedLibCoordinates = Collections.emptySet();
    private Set<String> applicationLibCoordinates = Collections.emptySet();
    private Set<String> testRunnerExportedLibCoordinates = Collections.emptySet();
    private Set<String> extraPrivilegedArtifacts = Collections.emptySet();
    private Set<Class> exportPluginClasses = Collections.emptySet();
    private boolean extensionMetadataGenerationEnabled = false;
    private List<URL> testRunnerPluginUrls = new ArrayList<URL>();
    private List<String> extraBootPackages;
    private List<String> extraBootResources;

    public ArtifactIsolatedClassLoaderBuilder setApplicationSharedLibCoordinates(Set<String> applicationSharedLibCoordinates) {
        this.applicationSharedLibCoordinates = applicationSharedLibCoordinates;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setApplicationLibCoordinates(Set<String> applicationLibCoordinates) {
        this.applicationLibCoordinates = applicationLibCoordinates;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestRunnerExportedLibCoordinates(Set<String> testRunnerExportedLibCoordinates) {
        this.testRunnerExportedLibCoordinates = testRunnerExportedLibCoordinates;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setClassPathClassifier(ClassPathClassifier classPathClassifier) {
        this.classPathClassifier = classPathClassifier;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setClassPathUrlProvider(ClassPathUrlProvider classPathUrlProvider) {
        this.classPathUrlProvider = classPathUrlProvider;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setRootArtifactClassesFolder(File rootArtifactClassesFolder) {
        this.rootArtifact = this.getRootArtifact(rootArtifactClassesFolder);
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setPluginResourcesFolder(File pluginResourcesFolder) {
        this.pluginResourcesFolder = pluginResourcesFolder;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExcludedArtifacts(Set<String> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtraBootPackages(List<String> extraBootPackages) {
        this.extraBootPackages = extraBootPackages;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtraBootResources(List<String> extraBootResources) {
        this.extraBootResources = extraBootResources;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtraPrivilegedArtifacts(Set<String> extraPrivilegedArtifacts) {
        this.extraPrivilegedArtifacts = extraPrivilegedArtifacts;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setProvidedExclusions(Set<String> providedExclusions) {
        this.providedExclusions = providedExclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestExclusions(Set<String> testExclusions) {
        this.testExclusions = testExclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestInclusions(Set<String> testInclusions) {
        this.testInclusions = testInclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExportPluginClasses(Set<Class> exportPluginClasses) {
        this.exportPluginClasses = exportPluginClasses;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtensionMetadataGeneration(boolean extensionMetadataGenerationEnabled) {
        this.extensionMetadataGenerationEnabled = extensionMetadataGenerationEnabled;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestRunnerPluginUrls(List<URL> testRunnerPluginUrls) {
        this.testRunnerPluginUrls = testRunnerPluginUrls;
        return this;
    }

    public ArtifactClassLoaderHolder build() {
        ClassPathClassifierContext context;
        Objects.requireNonNull(this.rootArtifact, "rootArtifact has to be set");
        Objects.requireNonNull(this.classPathUrlProvider, "classPathUrlProvider has to be set");
        Objects.requireNonNull(this.classPathClassifier, "classPathClassifier has to be set");
        try {
            context = new ClassPathClassifierContext(this.rootArtifact, this.pluginResourcesFolder, this.classPathUrlProvider.getURLs(), this.excludedArtifacts, this.extraBootPackages, this.extraBootResources, this.providedExclusions, this.testExclusions, this.testInclusions, this.applicationSharedLibCoordinates, this.exportPluginClasses, this.testRunnerPluginUrls, this.extensionMetadataGenerationEnabled, this.applicationLibCoordinates, this.testRunnerExportedLibCoordinates);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating the classification context", e);
        }
        ArtifactsUrlClassification artifactsUrlClassification = this.classPathClassifier.classify(context);
        return this.isolatedClassLoaderFactory.createArtifactClassLoader(context.getExtraBootPackages(), context.getExtraBootResources(), this.extraPrivilegedArtifacts, artifactsUrlClassification);
    }

    private Artifact getRootArtifact(File rootArtifactClassesFolder) {
        File pomFile = new File(rootArtifactClassesFolder.getParentFile().getParentFile(), POM_XML);
        this.logger.debug("Reading rootArtifact from pom file: {}", (Object)pomFile);
        return ArtifactFactory.createFromPomFile(pomFile);
    }
}

