/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.ResourcesGenerator;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;

class ExtensionsTestLoaderResourcesGenerator
implements ResourcesGenerator {
    private final File targetDirectory;
    private final Map<String, StringBuilder> contents = new HashMap<String, StringBuilder>();
    private final List<GeneratedResourceFactory> resourceFactories;

    ExtensionsTestLoaderResourcesGenerator(Collection<GeneratedResourceFactory> resourceFactories, File targetDirectory) {
        this.targetDirectory = targetDirectory;
        this.resourceFactories = List.copyOf(resourceFactories);
    }

    protected void write(GeneratedResource resource) {
        String resourceKey = Paths.get(this.targetDirectory.getPath(), resource.getPath()).toString();
        StringBuilder builder = this.contents.get(resourceKey);
        if (builder == null) {
            builder = new StringBuilder();
            this.contents.put(resourceKey, builder);
        }
        if (builder.length() > 0) {
            builder.append("\n");
        }
        builder.append(new String(resource.getContent()));
    }

    List<GeneratedResource> dumpAll() {
        List<GeneratedResource> allResources = this.contents.entrySet().stream().map(entry -> new GeneratedResource(false, (String)entry.getKey(), ((StringBuilder)entry.getValue()).toString().getBytes())).toList();
        allResources.forEach(resource -> {
            File targetFile = new File(resource.getPath());
            Path targetPath = Paths.get(targetFile.getAbsolutePath(), new String[0]);
            try {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.writeString(targetPath, (CharSequence)new String(resource.getContent()), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return allResources;
    }

    public List<GeneratedResource> generateFor(ExtensionModel extensionModel) {
        List<GeneratedResource> resources = this.resourceFactories.stream().map(factory -> factory.generateResource(extensionModel)).filter(Optional::isPresent).map(Optional::get).toList();
        resources.forEach(this::write);
        return resources;
    }
}

