/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.utils;

import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.bytebuddy.description.TypeVariableSource;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.EnumerationState;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.bytecode.StackSize;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.test.runner.api.DependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class RunnerModuleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerModuleUtils.class);
    public static final String EXCLUDED_PROPERTIES_FILE = "excluded.properties";
    public static final String EXCLUDED_ARTIFACTS = "excluded.artifacts";
    public static final String EXTRA_BOOT_PACKAGES = "extraBoot.packages";
    public static final String JAR_EXTENSION = "jar";
    private static String DEFAULT_TEST_SDK_API_VERSION_PROPERTY = "mule.testSdkApiVersion";
    private static final String SDK_API_GROUP_ID = "org.mule.sdk";
    private static final String SDK_API_ARTIFACT_ID = "mule-sdk-api";
    private static final String DEFAULT_SDK_API_VERSION = RunnerModuleUtils.getDefaultSdkApiVersionForTest();
    private static final Artifact DEFAULT_SDK_API_ARTIFACT = new DefaultArtifact("org.mule.sdk", "mule-sdk-api", "jar", DEFAULT_SDK_API_VERSION);

    private RunnerModuleUtils() {
    }

    public static Properties getExcludedProperties() throws IllegalStateException, IOException {
        Properties excludedProperties = new Properties();
        PropertiesUtils.discoverProperties((String)EXCLUDED_PROPERTIES_FILE).stream().forEach(properties -> properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> excludedProperties.merge(k, v, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(v1, v2) -> v1 + "," + v2)))));
        return excludedProperties;
    }

    public static Artifact getDefaultSdkApiArtifact() {
        return DEFAULT_SDK_API_ARTIFACT;
    }

    public static void assureSdkApiInClassLoader(ClassLoader extensionClassLoader, DependencyResolver dependencyResolver, List<RemoteRepository> repositories) {
        try {
            Class.forName("org.mule.sdk.api.runtime.parameter.ParameterResolver", true, extensionClassLoader);
        }
        catch (ClassNotFoundException cnf) {
            try {
                URL sdkApiUrl = dependencyResolver.resolveArtifact(RunnerModuleUtils.getDefaultSdkApiArtifact(), repositories).getArtifact().getFile().getAbsoluteFile().toURL();
                Method method = ReflectionUtils.findMethod(extensionClassLoader.getClass(), "addURL", URL.class);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)extensionClassLoader, sdkApiUrl);
                    return;
                }
                RunnerModuleUtils.addSdkApiClassesDynamically(extensionClassLoader, sdkApiUrl);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not assure sdk-api in extension classloader", e);
            }
        }
    }

    private static void addSdkApiClassesDynamically(ClassLoader extensionClassLoader, URL sdkApiUrl) throws IOException {
        boolean classAdded = true;
        HashSet<String> addedClasses = new HashSet<String>();
        while (classAdded) {
            classAdded = false;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(sdkApiUrl.getFile()));
            for (Map.Entry<TypeDescription, byte[]> classEntry : RunnerModuleUtils.getSdkClassMap(zipInputStream, addedClasses).entrySet()) {
                try {
                    HashMap<TypeDescription, byte[]> mapEntry = new HashMap<TypeDescription, byte[]>();
                    mapEntry.put(classEntry.getKey(), classEntry.getValue());
                    ClassLoadingStrategy.Default.INJECTION.load(extensionClassLoader, mapEntry);
                    addedClasses.add(classEntry.getKey().getName());
                    classAdded = true;
                    LOGGER.debug("Class {} was succesfully added to the extension classloader.", (Object)classEntry.getKey().getName());
                }
                catch (IllegalStateException e) {
                    LOGGER.debug(String.format("Class %s failed to be added to the extension classloader. Error message : %s", classEntry.getKey().getName(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private static Map<TypeDescription, byte[]> getSdkClassMap(ZipInputStream zipInputStream, Set<String> alreadyProcessed) throws IOException {
        HashMap<TypeDescription, byte[]> sdkClasses = new HashMap<TypeDescription, byte[]>();
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String zipEntryName;
            if (!zipEntry.isDirectory() && zipEntry.getName().endsWith(".class") && !alreadyProcessed.contains(zipEntryName = RunnerModuleUtils.getZipEntryClassName(zipEntry.getName()))) {
                byte[] fileBytes = ByteStreams.toByteArray((InputStream)zipInputStream);
                sdkClasses.put(new TypeDescription(){

                    public String getActualName() {
                        return null;
                    }

                    public int getModifiers() {
                        return 0;
                    }

                    public boolean isFinal() {
                        return false;
                    }

                    public boolean isSynthetic() {
                        return false;
                    }

                    public SyntheticState getSyntheticState() {
                        return null;
                    }

                    public boolean isPublic() {
                        return false;
                    }

                    public boolean isProtected() {
                        return false;
                    }

                    public boolean isPackagePrivate() {
                        return false;
                    }

                    public boolean isPrivate() {
                        return false;
                    }

                    public boolean isStatic() {
                        return false;
                    }

                    public boolean isDeprecated() {
                        return false;
                    }

                    public Ownership getOwnership() {
                        return null;
                    }

                    public Visibility getVisibility() {
                        return null;
                    }

                    public boolean isEnum() {
                        return false;
                    }

                    public EnumerationState getEnumerationState() {
                        return null;
                    }

                    public boolean isAbstract() {
                        return false;
                    }

                    public boolean isInterface() {
                        return false;
                    }

                    public boolean isAnnotation() {
                        return false;
                    }

                    public TypeManifestation getTypeManifestation() {
                        return null;
                    }

                    public Iterator<TypeDefinition> iterator() {
                        return null;
                    }

                    public AnnotationList getDeclaredAnnotations() {
                        return null;
                    }

                    public TypeList.Generic getTypeVariables() {
                        return null;
                    }

                    public TypeVariableSource getEnclosingSource() {
                        return null;
                    }

                    public boolean isInferrable() {
                        return false;
                    }

                    public TypeDescription.Generic findVariable(String symbol) {
                        return null;
                    }

                    public <T> T accept(TypeVariableSource.Visitor<T> visitor) {
                        return null;
                    }

                    public boolean isGenerified() {
                        return false;
                    }

                    public String getName() {
                        return zipEntryName;
                    }

                    public String getInternalName() {
                        return null;
                    }

                    public String getDescriptor() {
                        return null;
                    }

                    public String getGenericSignature() {
                        return null;
                    }

                    public boolean isVisibleTo(TypeDescription typeDescription) {
                        return false;
                    }

                    public boolean isAccessibleTo(TypeDescription typeDescription) {
                        return false;
                    }

                    public TypeDescription.Generic asGenericType() {
                        return null;
                    }

                    public TypeDescription asErasure() {
                        return null;
                    }

                    public TypeDescription.Generic getSuperClass() {
                        return null;
                    }

                    public TypeList.Generic getInterfaces() {
                        return null;
                    }

                    public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
                        return null;
                    }

                    public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                        return null;
                    }

                    public boolean isInstance(Object value) {
                        return false;
                    }

                    public boolean isAssignableFrom(Class<?> type) {
                        return false;
                    }

                    public boolean isAssignableFrom(TypeDescription typeDescription) {
                        return false;
                    }

                    public boolean isAssignableTo(Class<?> type) {
                        return false;
                    }

                    public boolean isAssignableTo(TypeDescription typeDescription) {
                        return false;
                    }

                    public boolean isInHierarchyWith(Class<?> type) {
                        return false;
                    }

                    public boolean isInHierarchyWith(TypeDescription typeDescription) {
                        return false;
                    }

                    public TypeDescription getComponentType() {
                        return null;
                    }

                    public TypeDefinition.Sort getSort() {
                        return null;
                    }

                    public String getTypeName() {
                        return null;
                    }

                    public StackSize getStackSize() {
                        return null;
                    }

                    public boolean isArray() {
                        return false;
                    }

                    public boolean isPrimitive() {
                        return false;
                    }

                    public boolean represents(Type type) {
                        return false;
                    }

                    public TypeDescription getDeclaringType() {
                        return null;
                    }

                    public TypeList getDeclaredTypes() {
                        return null;
                    }

                    public MethodDescription.InDefinedShape getEnclosingMethod() {
                        return null;
                    }

                    public TypeDescription getEnclosingType() {
                        return null;
                    }

                    public int getActualModifiers(boolean superFlag) {
                        return 0;
                    }

                    public String getSimpleName() {
                        return null;
                    }

                    public String getCanonicalName() {
                        return null;
                    }

                    public boolean isAnonymousType() {
                        return false;
                    }

                    public boolean isLocalType() {
                        return false;
                    }

                    public boolean isMemberType() {
                        return false;
                    }

                    public PackageDescription getPackage() {
                        return null;
                    }

                    public AnnotationList getInheritedAnnotations() {
                        return null;
                    }

                    public boolean isSamePackage(TypeDescription typeDescription) {
                        return false;
                    }

                    public boolean isPrimitiveWrapper() {
                        return false;
                    }

                    public boolean isAnnotationReturnType() {
                        return false;
                    }

                    public boolean isAnnotationValue() {
                        return false;
                    }

                    public boolean isAnnotationValue(Object value) {
                        return false;
                    }

                    public boolean isPackageType() {
                        return false;
                    }

                    public int getInnerClassCount() {
                        return 0;
                    }

                    public boolean isInnerClass() {
                        return false;
                    }

                    public boolean isNestedClass() {
                        return false;
                    }

                    public TypeDescription asBoxed() {
                        return null;
                    }

                    public TypeDescription asUnboxed() {
                        return null;
                    }

                    public Object getDefaultValue() {
                        return null;
                    }

                    public TypeDescription getNestHost() {
                        return null;
                    }

                    public TypeList getNestMembers() {
                        return null;
                    }

                    public boolean isNestHost() {
                        return false;
                    }

                    public boolean isNestMateOf(Class<?> type) {
                        return false;
                    }

                    public boolean isNestMateOf(TypeDescription typeDescription) {
                        return false;
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof TypeDescription) {
                            return this.getName().equals(((TypeDescription)obj).getName());
                        }
                        return false;
                    }

                    public int hashCode() {
                        return this.getName().hashCode();
                    }
                }, fileBytes);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return sdkClasses;
    }

    private static String getZipEntryClassName(String zipEntryName) {
        String zipEntryClassName = zipEntryName.replace("/", ".");
        zipEntryClassName = zipEntryClassName.substring(0, zipEntryClassName.lastIndexOf("."));
        return zipEntryClassName;
    }

    private static String getDefaultSdkApiVersionForTest() {
        return System.getProperty(DEFAULT_TEST_SDK_API_VERSION_PROPERTY, "0.4.0");
    }
}

