/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classification;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public abstract class AbstractPatternDependencyFilter
implements DependencyFilter {
    public static final String MAVEN_COORDINATES_SEPARATOR = ":";
    public static final String STAR_SYMBOL = "*";
    private final Set<String> patterns = new HashSet<String>();

    public AbstractPatternDependencyFilter(Collection<String> coordinates) {
        this.patterns.addAll(coordinates);
    }

    public AbstractPatternDependencyFilter(String ... coordinates) {
        this(Arrays.asList(coordinates));
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        return this.accept(dependency.getArtifact());
    }

    protected boolean accept(Artifact artifact) {
        for (String pattern : this.patterns) {
            boolean matched = this.accept(artifact, pattern);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String pattern) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion()};
        String[] patternTokens = pattern.split(MAVEN_COORDINATES_SEPARATOR);
        boolean matched = patternTokens.length <= tokens.length;
        for (int i = 0; matched && i < patternTokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    private boolean matches(String token, String pattern) {
        boolean matches;
        if (this.supportFullWildcardAndImpliedWildcard(pattern)) {
            matches = true;
        } else if (this.supportContainsWildcard(pattern)) {
            String contains = pattern.substring(1, pattern.length() - 1);
            matches = token.contains(contains);
        } else if (this.supportLeadingWildcard(pattern)) {
            String suffix = pattern.substring(1, pattern.length());
            matches = token.endsWith(suffix);
        } else if (this.supportTrailingWildcard(pattern)) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else {
            matches = token.equals(pattern);
        }
        return matches;
    }

    private boolean supportFullWildcardAndImpliedWildcard(String pattern) {
        return STAR_SYMBOL.equals(pattern) || pattern.length() == 0;
    }

    private boolean supportContainsWildcard(String pattern) {
        return this.supportLeadingWildcard(pattern) && this.supportTrailingWildcard(pattern);
    }

    private boolean supportLeadingWildcard(String pattern) {
        return pattern.startsWith(STAR_SYMBOL);
    }

    private boolean supportTrailingWildcard(String pattern) {
        return pattern.endsWith(STAR_SYMBOL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractPatternDependencyFilter that = (AbstractPatternDependencyFilter)obj;
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }
}

