/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.module.service.api.discoverer.MuleServiceModelLoader;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResourcesResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArtifactUrlClassification resolveServiceResourcesFor(ArtifactUrlClassification serviceUrlClassification) {
        try (URLClassLoader classLoader = new URLClassLoader(serviceUrlClassification.getUrls().toArray(new URL[0]), null);){
            MuleServiceModel muleServiceModel = MuleServiceModelLoader.loadServiceModel((ClassLoader)classLoader);
            ArtifactUrlClassification artifactUrlClassification = new ArtifactUrlClassification(serviceUrlClassification.getArtifactId(), ((MuleServiceContractModel)muleServiceModel.getContracts().get(0)).getServiceProviderClassName(), serviceUrlClassification.getUrls());
            return artifactUrlClassification;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

