/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.test.runner.api.PluginUrlClassification;

public class PluginLookPolicyFactory {
    public ClassLoaderLookupPolicy createLookupPolicy(PluginUrlClassification pluginClassification, List<PluginUrlClassification> pluginClassifications, ClassLoaderLookupPolicy parentLookupPolicies, List<ArtifactClassLoader> classLoaders) {
        HashMap<String, LookupStrategy> pluginsLookupPolicies = new HashMap<String, LookupStrategy>();
        for (PluginUrlClassification dependencyPluginClassification : pluginClassifications) {
            if (dependencyPluginClassification.getArtifactId().equals(pluginClassification.getArtifactId()) || !pluginClassification.getPluginDependencies().contains(dependencyPluginClassification.getArtifactId())) continue;
            LookupStrategy lookUpPolicyStrategy = ParentFirstLookupStrategy.PARENT_FIRST;
            for (String exportedPackage : dependencyPluginClassification.getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, lookUpPolicyStrategy);
            }
            if (!this.isPrivilegedPluginDependency(pluginClassification, dependencyPluginClassification)) continue;
            Optional<ArtifactClassLoader> pluginClassLoader = classLoaders.stream().filter(c -> c.getArtifactId().contains(dependencyPluginClassification.getName())).findFirst();
            if (!pluginClassLoader.isPresent()) {
                throw new IllegalStateException("Cannot find classloader for plugin: " + dependencyPluginClassification.getArtifactId());
            }
            lookUpPolicyStrategy = new DelegateOnlyLookupStrategy(pluginClassLoader.get().getClassLoader());
            for (String exportedPackage : dependencyPluginClassification.getPrivilegedExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, lookUpPolicyStrategy);
            }
        }
        return parentLookupPolicies.extend(pluginsLookupPolicies);
    }

    private boolean isPrivilegedPluginDependency(PluginUrlClassification pluginClassification, PluginUrlClassification dependencyPluginClassification) {
        if (dependencyPluginClassification.getPrivilegedExportedPackages().isEmpty()) {
            return false;
        }
        return dependencyPluginClassification.getPrivilegedArtifacts().stream().filter(artifact -> pluginClassification.getName().startsWith(artifact + ":")).findFirst().isPresent();
    }
}

