/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.api.discoverer.ModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.jpms.api.MuleContainerModule;

public class TestModuleDiscoverer
implements ModuleDiscoverer {
    private final Set<String> privilegedArtifactIds;
    private final ModuleDiscoverer delegateModuleDiscoverer;

    public TestModuleDiscoverer(Set<String> privilegedArtifactIds, ModuleDiscoverer moduleDiscoverer) {
        Preconditions.checkArgument((privilegedArtifactIds != null ? 1 : 0) != 0, (String)"privilegedArtifactIds cannot be null");
        Preconditions.checkArgument((moduleDiscoverer != null ? 1 : 0) != 0, (String)"moduleDiscoverer cannot be null");
        this.privilegedArtifactIds = privilegedArtifactIds;
        this.delegateModuleDiscoverer = moduleDiscoverer;
    }

    public List<MuleContainerModule> discover() {
        DefaultModuleRepository containerModuleDiscoverer = new DefaultModuleRepository(this.delegateModuleDiscoverer);
        List discoveredModules = containerModuleDiscoverer.getModules();
        ArrayList<MuleContainerModule> updateModules = new ArrayList<MuleContainerModule>(discoveredModules.size());
        for (MuleContainerModule discoveredModule : discoveredModules) {
            if (!discoveredModule.getPrivilegedExportedPackages().isEmpty()) {
                discoveredModule = this.updateModuleForTests(discoveredModule);
            }
            updateModules.add(discoveredModule);
        }
        return updateModules;
    }

    private MuleContainerModule updateModuleForTests(MuleContainerModule discoveredModule) {
        HashSet<String> privilegedArtifacts = new HashSet<String>(discoveredModule.getPrivilegedArtifacts());
        privilegedArtifacts.addAll(this.privilegedArtifactIds);
        return new MuleModule(discoveredModule.getName(), discoveredModule.getExportedPackages(), discoveredModule.getExportedPaths(), discoveredModule.getPrivilegedExportedPackages(), privilegedArtifacts, discoveredModule instanceof MuleModule ? ((MuleModule)discoveredModule).getExportedServices() : Collections.emptyList());
    }
}

