/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.service;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import jakarta.inject.Inject;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mule.functional.junit4.ArtifactAstXmlParserConfigurationBuilder;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.additional.api.test.TestService;
import org.mule.runtime.core.api.config.ConfigurationBuilder;

@Features(value={@Feature(value="Services"), @Feature(value="Java Platform Module System"), @Feature(value="Classloading Isolation")})
public class ServiceLibWithPrivilegedAdditionalLibTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private TestService testService;

    protected ConfigurationBuilder getBuilder() throws Exception {
        ArtifactAstXmlParserConfigurationBuilder builder = new ArtifactAstXmlParserConfigurationBuilder(Collections.emptyMap(), this.disableXmlValidations(), this.enableLazyInit(), false, false, new String[0], this.getExpressionLanguageMetadataService());
        this.configureSpringConfigurationBuilder((ConfigurationBuilder)builder);
        return builder;
    }

    @Test
    public void serviceLoadedAndInjected() {
        MatcherAssert.assertThat((Object)this.testService, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void javaAccessRestrictionsEnforced() {
        IllegalAccessError thrown = (IllegalAccessError)Assertions.assertThrows(IllegalAccessError.class, () -> this.testService.doSomething());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"cannot access class org.mule.runtime.additional.api.test.TestService (in module org.mule.runtime.additional) because module org.mule.runtime.additional does not export org.mule.runtime.additional.api.test to"));
    }
}

