/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

import org.mule.api.annotation.jpms.RequiredOpens;
import org.mule.api.annotation.jpms.ServiceModule;

/**
 * A Service Module has a lib that uses a privileged API.
 */
@ServiceModule(
    requiredOpens = {
        @RequiredOpens(
            moduleName = "org.mule.runtime.additional",
            packageNames = {
                "org.mule.runtime.additional.api.test"
            },
            targetModules = {
                "org.mule.service.test",
                "org.mule.service.test.lib"
            })
    })
module org.mule.service.test {

  requires org.mule.runtime.api;
  requires org.mule.runtime.additional;
  requires org.mule.service.test.lib;

  exports org.mule.service.test.provider to
      org.mule.runtime.service;

}
