/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.test.provider;

import org.mule.runtime.additional.api.test.TestService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.service.test.AdditionalTestService;

public class AdditionalTestServiceProvider implements ServiceProvider {

  private final ServiceDefinition serviceDefinition =
      new ServiceDefinition(TestService.class, new AdditionalTestService());

  @Override
  public ServiceDefinition getServiceDefinition() {
    return serviceDefinition;
  }

}
