/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideScatterGatherErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "scatter-gather-flow";
    private static final String CONFIG_FILE = "tracing/scatter-gather-error.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/scatter-gather";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SCATTER_GATHER_SPAN_NAME = "mule:scatter-gather";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:scatter-gather:route";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    private static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    private static final String ANY_EXPECTED_ERROR_TYPE = "ANY:EXPECTED";
    private static final String MULE_COMPOSITE_ROUTING_ERROR_TYPE = "MULE:COMPOSITE_ROUTING";
    private static final String SCATTER_GATHER_LOCATION = "scatter-gather-flow/processors/0";
    private static final String TEST_ARTIFACT_ID = "OverrideScatterGatherErrorOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpans;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-scatter-gather-debug", 7, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy()}, {"overview-scatter-gather-monitoring", 7, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-debug", 8, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-overview", 2, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy()}, {"debug-scatter-gather-monitoring", 8, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getDebugScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"debug-scatter-gather-overview", 2, OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getDebugScatterGatherOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideScatterGatherErrorOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpans, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpans = expectedSpans;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewScatterGatherDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addStatusData("ERROR").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)SCATTER_GATHER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringScatterGatherDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addStatusData("ERROR").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)SCATTER_GATHER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugScatterGatherOverviewExpectedSpanTestHierarchy() {
        return OverrideScatterGatherErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideScatterGatherErrorOpenTelemetryTracingTestCase.this.expectedSpans;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans(), "OverrideScatterGatherErrorOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]").assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

