/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideAsyncSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/async-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/async";
    private static final String FLOW_NAME = "async-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";
    private static final String EXPECTED_ASYNC_SPAN_NAME = "mule:async";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-async-debug", 4, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getOverviewAsyncDebugExpectedSpanTestHierarchy()}, {"overview-async-monitoring", 4, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getOverviewAsyncMonitoringExpectedSpanTestHierarchy()}, {"monitoring-async-debug", 6, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getMonitoringAsyncDebugExpectedSpanTestHierarchy()}, {"monitoring-async-overview", 3, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getMonitoringAsyncOverviewExpectedSpanTestHierarchy()}, {"debug-async-monitoring", 6, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getDebugAsyncMonitoringExpectedSpanTestHierarchy()}, {"debug-async-overview", 3, OverrideAsyncSuccessOpenTelemetryTracingTestCase.getDebugAsyncOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideAsyncSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewAsyncDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_ASYNC_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewAsyncMonitoringExpectedSpanTestHierarchy() {
        return OverrideAsyncSuccessOpenTelemetryTracingTestCase.getOverviewAsyncDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringAsyncDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).child(EXPECTED_ASYNC_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).endChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringAsyncOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).child(EXPECTED_SET_VARIABLE_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugAsyncMonitoringExpectedSpanTestHierarchy() {
        return OverrideAsyncSuccessOpenTelemetryTracingTestCase.getMonitoringAsyncDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugAsyncOverviewExpectedSpanTestHierarchy() {
        return OverrideAsyncSuccessOpenTelemetryTracingTestCase.getMonitoringAsyncOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            CountDownLatch asyncTerminationLatch = new CountDownLatch(1);
            FlowRunner runner = (FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test");
            ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> asyncTerminationLatch.countDown());
            runner.run();
            asyncTerminationLatch.await();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideAsyncSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

