/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class ForEachSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:foreach:iteration";
    public static final String EXPECTED_FOREACH_SPAN_NAME = "mule:foreach";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String FOR_EACH_TELEMETRY_FLOW = "for-each-telemetryFlow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final int NUMBER_OF_ROUTES = 3;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, ForEachSuccessOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 13, ForEachSuccessOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 13, ForEachSuccessOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME);
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_FOREACH_SPAN_NAME).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_VARIABLE_SPAN_NAME).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_VARIABLE_SPAN_NAME).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_VARIABLE_SPAN_NAME).endChildren().endChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return ForEachSuccessOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy();
    }

    public ForEachSuccessOpenTelemetryTracingTestCase(String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        this.configureTracingLevelSystemProperties(traceLevel.toLowerCase());
    }

    protected String getConfigFile() {
        return "tracing/foreach-success.xml";
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FOR_EACH_TELEMETRY_FLOW).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == ForEachSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans()).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

