/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class JavaSdkRoutersOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String SDK_ROUTER_TEST_FLOW = "listOfRoutesRouter";
    @Inject
    PrivilegedProfilingService profilingService;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;

    public JavaSdkRoutersOpenTelemetryTracingTestCase(String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        this.configureTracingLevelSystemProperties(traceLevel.toLowerCase());
    }

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{TracingLevel.MONITORING.name(), 6, JavaSdkRoutersOpenTelemetryTracingTestCase.getMonitoringExpectedSpanHierarchy()}});
    }

    protected String getConfigFile() {
        return "tracing/sdk-router.xml";
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(SDK_ROUTER_TEST_FLOW).withVariable("executeWhen1", (Object)true)).withVariable("executeWhen2", (Object)false)).withVariable("executeWhen3", (Object)true)).withVariable("executeOther", (Object)false)).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == JavaSdkRoutersOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans()).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME);
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child("heisenberg:many-routes-router").beginChildren().child("heisenberg:when").beginChildren().child("mule:logger").endChildren().child("heisenberg:when").beginChildren().child("heisenberg:non-blocking").endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }
}

