/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideCustomScopeSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/custom-scope-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/custom-scope";
    private static final String FLOW_NAME = "custom-scope-flow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_CUSTOM_SCOPE_SPAN_NAME = "heisenberg:execute-anything";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String FLOW_LOCATION = "custom-scope-flow";
    private static final String CUSTOM_SCOPE_LOCATION = "custom-scope-flow/processors/0";
    private static final String LOGGER_LOCATION = "custom-scope-flow/processors/0/processors/0";
    private static final String TEST_ARTIFACT_ID = "OverrideCustomScopeSuccessOpenTelemetryTracingTestCase#testFlow";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-custom-scope-debug", 7, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getOverviewCustomScopeDebugExpectedSpanTestHierarchy()}, {"overview-custom-scope-monitoring", 3, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getOverviewCustomScopeMonitoringExpectedSpanTestHierarchy()}, {"monitoring-custom-scope-debug", 7, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getMonitoringCustomScopeDebugExpectedSpanTestHierarchy()}, {"monitoring-custom-scope-overview", 1, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getMonitoringCustomScopeOverviewExpectedSpanTestHierarchy()}, {"debug-custom-scope-monitoring", 3, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getDebugCustomScopeMonitoringExpectedSpanTestHierarchy()}, {"debug-custom-scope-overview", 1, OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getDebugCustomScopeOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideCustomScopeSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        String tracingLevelConfigurationFolderResourcePath = String.format("%s/%s", OVERRIDE_FOLDER_NAME, tracingLevelConf);
        this.configureTracingLevelSystemProperties(tracingLevelConfigurationFolderResourcePath);
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewCustomScopeDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CUSTOM_SCOPE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)LOGGER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewCustomScopeMonitoringExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CUSTOM_SCOPE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)LOGGER_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringCustomScopeDebugExpectedSpanTestHierarchy() {
        return OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getOverviewCustomScopeDebugExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringCustomScopeOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugCustomScopeMonitoringExpectedSpanTestHierarchy() {
        return OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getOverviewCustomScopeMonitoringExpectedSpanTestHierarchy();
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugCustomScopeOverviewExpectedSpanTestHierarchy() {
        return OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.getMonitoringCustomScopeOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner("custom-scope-flow").withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideCustomScopeSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            String artifactId = "OverrideCustomScopeSuccessOpenTelemetryTracingTestCase#testFlow[TracingLevelConf: " + this.tracingLevelConf + "]";
            this.spanHierarchyRetriever.apply(exportedSpans, artifactId).assertSpanTree();
            exportedSpans.forEach(span -> MatcherAssert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

