/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class MuleSdkConnectionHandlingOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_PET_STORE_GET_CONNECTION_AGE_SPAN = "petstore:get-connection-age";
    public static final String EXPECTED_PET_STORE_GET_PETS_SPAN = "petstore:get-pets";
    public static final String EXPECTED_MULE_GET_CONNECTION_SPAN = "mule:get-connection";
    private static final String OPERATION_WITH_CONNECTION = "operation-with-connection";
    private static final String OPERATION_WITH_FAILING_CONNECTION = "operation-with-failing-connection";
    private static final String OPERATION_WITH_CONNECTION_RETRY = "operation-with-connection-retry";
    private ExportedSpanSniffer exportedSpanSniffer;
    @Inject
    private PrivilegedProfilingService profilingService;
    private final String lazyConnections;
    private final String flowName;
    private final Supplier<SpanTestHierarchy> expectedTrace;

    public MuleSdkConnectionHandlingOpenTelemetryTracingTestCase(String lazyConnections, TracingLevel tracingLevel, String flowName, Supplier<SpanTestHierarchy> expectedTrace) {
        this.lazyConnections = lazyConnections;
        this.flowName = flowName;
        this.expectedTrace = expectedTrace;
        this.configureTracingLevelSystemProperties(tracingLevel.name().toLowerCase());
    }

    protected String getConfigFile() {
        return "tracing/mule-sdk-connection-handling.xml";
    }

    @Parameterized.Parameters(name="flowName: {2} - tracingLevel: {1} - lazyConnections: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"true", TracingLevel.OVERVIEW, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewSpans()}, {"true", TracingLevel.OVERVIEW, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewFailingSpans()}, {"true", TracingLevel.OVERVIEW, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewRetrySpans()}, {"false", TracingLevel.OVERVIEW, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewSpans()}, {"false", TracingLevel.OVERVIEW, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewFailingSpans()}, {"false", TracingLevel.OVERVIEW, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewRetrySpans()}, {"true", TracingLevel.MONITORING, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringSpans()}, {"true", TracingLevel.MONITORING, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringFailingSpans()}, {"true", TracingLevel.MONITORING, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringRetrySpans()}, {"false", TracingLevel.MONITORING, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringSpans()}, {"false", TracingLevel.MONITORING, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringFailingSpans()}, {"false", TracingLevel.MONITORING, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringRetrySpans()}, {"true", TracingLevel.DEBUG, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugLazySpans()}, {"true", TracingLevel.DEBUG, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugLazyFailingSpans()}, {"true", TracingLevel.DEBUG, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugLazyRetrySpans()}, {"false", TracingLevel.DEBUG, OPERATION_WITH_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugEagerSpans()}, {"false", TracingLevel.DEBUG, OPERATION_WITH_FAILING_CONNECTION, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugEagerFailingSpans()}, {"false", TracingLevel.DEBUG, OPERATION_WITH_CONNECTION_RETRY, MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedDebugEagerRetrySpans()});
    }

    @Before
    public void initialize() {
        this.exportedSpanSniffer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
    }

    @After
    public void dispose() {
        this.exportedSpanSniffer.dispose();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(new ConfigurationBuilder(){

            public void configure(MuleContext muleContext) {
                muleContext.getDeploymentProperties().setProperty("mule.application.deployment.lazyConnections", MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.this.lazyConnections);
            }

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }
        });
    }

    @Test
    public void assertConnectionHandlingTrace() throws Exception {
        try {
            ((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"test")).run();
        }
        catch (MuleException e) {
            MatcherAssert.assertThat((Object)e.getExceptionInfo().getErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"CONNECTIVITY"));
        }
        MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.assertTrace(this.exportedSpanSniffer, this.expectedTrace.get());
    }

    private static Supplier<SpanTestHierarchy> expectedOverviewSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME);
    }

    private static Supplier<SpanTestHierarchy> expectedMonitoringSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_PET_STORE_GET_CONNECTION_AGE_SPAN).endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugEagerSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_PET_STORE_GET_CONNECTION_AGE_SPAN).beginChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugLazySpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_PET_STORE_GET_CONNECTION_AGE_SPAN).beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren().endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedOverviewFailingSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY");
    }

    private static Supplier<SpanTestHierarchy> expectedOverviewRetrySpans() {
        return MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedOverviewFailingSpans();
    }

    private static Supplier<SpanTestHierarchy> expectedMonitoringFailingSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:on-error-propagate").child(EXPECTED_PET_STORE_GET_PETS_SPAN).addExceptionData("PETSTORE:CONNECTIVITY").endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedMonitoringRetrySpans() {
        return MuleSdkConnectionHandlingOpenTelemetryTracingTestCase.expectedMonitoringFailingSpans();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugLazyFailingSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:on-error-propagate").child(EXPECTED_PET_STORE_GET_PETS_SPAN).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren().endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugLazyRetrySpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:on-error-propagate").child(EXPECTED_PET_STORE_GET_PETS_SPAN).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren().endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugEagerFailingSpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:on-error-propagate").child(EXPECTED_PET_STORE_GET_PETS_SPAN).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren();
    }

    private static Supplier<SpanTestHierarchy> expectedDebugEagerRetrySpans() {
        return () -> new SpanTestHierarchy().withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:on-error-propagate").child(EXPECTED_PET_STORE_GET_PETS_SPAN).addExceptionData("PETSTORE:CONNECTIVITY").beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").child("mule:value-resolution").endChildren().child(EXPECTED_MULE_GET_CONNECTION_SPAN).child(EXPECTED_MULE_GET_CONNECTION_SPAN).endChildren().endChildren();
    }

    private static void assertTrace(final ExportedSpanSniffer exportedSpanSniffer, final SpanTestHierarchy expectedSpanTestHierarchy) {
        new PollingProber(30000L, 100L).check((Probe)new JUnitProbe(){
            private final int expectedSpans;
            {
                this.expectedSpans = expectedSpanTestHierarchy.size();
            }

            protected boolean test() {
                Collection exportedSpans = exportedSpanSniffer.getExportedSpans();
                return exportedSpans.size() == this.expectedSpans;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        expectedSpanTestHierarchy.withCapturedSpans(exportedSpanSniffer.getExportedSpans()).assertSpanTree();
    }
}

