/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import java.io.File;
import java.net.URL;
import org.junit.Rule;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public abstract class OpenTelemetryTracingTestCase
extends MuleArtifactFunctionalTestCase {
    @Rule
    public SystemProperty enableTracing = new SystemProperty("mule.openTelemetry.tracer.exporter.enabled", Boolean.TRUE.toString());
    @Rule
    public SystemProperty doNotSample = new SystemProperty("mule.openTelemetry.tracer.exporter.sampler.type", "always_on");
    @Rule
    public SystemProperty tracingLevelConfigurationFileNameProperty;
    @Rule
    public SystemProperty tracingLevelConfigurationFilePathProperty;

    protected void configureTracingLevelSystemProperties(String configurationFolderResource) {
        this.tracingLevelConfigurationFileNameProperty = new SystemProperty("mule.openTelemetry.tracer.level.configurationFileName", "tracing-level.conf");
        this.tracingLevelConfigurationFilePathProperty = new SystemProperty("mule.openTelemetry.tracer.level.configurationFilePath", this.resolveAbsoluteConfigurationPath(configurationFolderResource));
    }

    protected String resolveAbsoluteConfigurationPath(String tracingLevelResourcePath) {
        URL resourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(tracingLevelResourcePath);
        if (resourceUrl == null) {
            throw new IllegalStateException(String.format("Configuration directory not found: %s", tracingLevelResourcePath));
        }
        try {
            return new File(resourceUrl.toURI()).getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to resolve configuration path: %s", tracingLevelResourcePath), e);
        }
    }
}

