/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideScatterGatherSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "scatter-gather-flow";
    private static final String CONFIG_FILE = "tracing/scatter-gather-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/scatter-gather";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SCATTER_GATHER_SPAN_NAME = "mule:scatter-gather";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:scatter-gather:route";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private final String tracingLevelConf;
    private final int expectedSpans;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-scatter-gather-debug", 6, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy()}, {"overview-scatter-gather-monitoring", 6, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-debug", 7, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-overview", 2, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy()}, {"debug-scatter-gather-monitoring", 7, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getDebugScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"debug-scatter-gather-overview", 2, OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getDebugScatterGatherOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideScatterGatherSuccessOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpans, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpans = expectedSpans;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        String tracingLevelConfigurationFolderResourcePath = String.format("%s/%s", OVERRIDE_FOLDER_NAME, tracingLevelConf);
        this.configureTracingLevelSystemProperties(tracingLevelConfigurationFolderResourcePath);
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewScatterGatherDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringScatterGatherDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugScatterGatherOverviewExpectedSpanTestHierarchy() {
        return OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideScatterGatherSuccessOpenTelemetryTracingTestCase.this.expectedSpans;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans()).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

