/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "until-successful-flow";
    private static final String CONFIG_FILE = "tracing/until-successful-error.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/until-successful";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME = "mule:until-successful";
    private static final String EXPECTED_ATTEMPT_SPAN_NAME = "mule:until-successful:attempt";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    private static final String ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    private static final String ANY_EXPECTED_ERROR_TYPE = "ANY:EXPECTED";
    private static final String MULE_RETRY_EXHAUSTED_ERROR_TYPE = "MULE:RETRY_EXHAUSTED";
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-until-successful-debug", 11, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy()}, {"overview-until-successful-monitoring", 11, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulMonitoringExpectedSpanTestHierarchy()}, {"monitoring-until-successful-debug", 12, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulDebugExpectedSpanTestHierarchy()}, {"monitoring-until-successful-overview", 2, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy()}, {"debug-until-successful-monitoring", 12, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getDebugUntilSuccessfulMonitoringExpectedSpanTestHierarchy()}, {"debug-until-successful-overview", 2, OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getDebugUntilSuccessfulOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
        String tracingLevelConfigurationFolderResourcePath = String.format("%s/%s", OVERRIDE_FOLDER_NAME, tracingLevelConf);
        this.configureTracingLevelSystemProperties(tracingLevelConfigurationFolderResourcePath);
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_RETRY_EXHAUSTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME).addExceptionData(MULE_RETRY_EXHAUSTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewUntilSuccessfulMonitoringExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getOverviewUntilSuccessfulDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringUntilSuccessfulDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_RETRY_EXHAUSTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME).addExceptionData(MULE_RETRY_EXHAUSTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_RETRY_EXHAUSTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugUntilSuccessfulMonitoringExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugUntilSuccessfulOverviewExpectedSpanTestHierarchy() {
        return OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.getMonitoringUntilSuccessfulOverviewExpectedSpanTestHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideUntilSuccessfulErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

