/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.protocol.AbstractUnaryGrpcService;
import com.linecorp.armeria.testing.junit4.server.SelfSignedCertificateRule;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.runner.RunnerDelegateTo;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

@RunnerDelegateTo(value=Parameterized.class)
public abstract class AbstractTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final DockerImageName COLLECTOR_IMAGE = DockerImageName.parse((String)"ghcr.io/open-telemetry/opentelemetry-java/otel-collector");
    private static final Integer COLLECTOR_OTLP_GRPC_PORT = 4317;
    private static final Integer COLLECTOR_OTLP_HTTP_PORT = 4318;
    private static final Integer COLLECTOR_OTLP_GRPC_MTLS_PORT = 5317;
    private static final Integer COLLECTOR_OTLP_HTTP_MTLS_PORT = 5318;
    private static final Integer COLLECTOR_HEALTH_CHECK_PORT = 13133;
    protected final String exporterType;
    private final String schema;
    private final int port;
    private final String path;
    private final boolean secure;
    protected GenericContainer<?> collector;
    @ClassRule
    public static SelfSignedCertificateRule serverTls = new SelfSignedCertificateRule();
    @ClassRule
    public static SelfSignedCertificateRule clientTls = new SelfSignedCertificateRule();
    @ClassRule
    public static final TestGrpcServerRule server = new TestGrpcServerRule();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"GRPC", "http://", COLLECTOR_OTLP_GRPC_PORT, "", false}, {"HTTP", "http://", COLLECTOR_OTLP_HTTP_PORT, "/v1/traces", false}, {"GRPC", "https://", COLLECTOR_OTLP_GRPC_MTLS_PORT, "", true}, {"HTTP", "https://", COLLECTOR_OTLP_HTTP_MTLS_PORT, "/v1/traces", true});
    }

    public AbstractTracingTestCase(String exporterType, String schema, int port, String path, boolean secure) {
        this.exporterType = exporterType;
        this.schema = schema;
        this.port = port;
        this.path = path;
        this.secure = secure;
    }

    @Before
    public void before() {
        ClassUtils.withContextClassLoader((ClassLoader)GenericContainer.class.getClassLoader(), () -> {
            Testcontainers.exposeHostPorts((int[])new int[]{server.httpPort()});
            this.collector = new GenericContainer(COLLECTOR_IMAGE).withImagePullPolicy(PullPolicy.alwaysPull()).withEnv("LOGGING_EXPORTER_LOG_LEVEL", "INFO").withCopyFileToContainer(MountableFile.forHostPath((Path)serverTls.certificateFile().toPath(), (Integer)365), "/server.cert").withCopyFileToContainer(MountableFile.forHostPath((Path)serverTls.privateKeyFile().toPath(), (Integer)365), "/server.key").withCopyFileToContainer(MountableFile.forHostPath((Path)clientTls.certificateFile().toPath(), (Integer)365), "/client.cert").withEnv("MTLS_CLIENT_CERTIFICATE", "/client.cert").withEnv("MTLS_SERVER_CERTIFICATE", "/server.cert").withEnv("MTLS_SERVER_KEY", "/server.key").withEnv("OTLP_EXPORTER_ENDPOINT", "host.testcontainers.internal:" + server.httpPort()).withClasspathResourceMapping("otel.yaml", "/otel.yaml", BindMode.READ_ONLY).withCommand(new String[]{"--config", "/otel.yaml"}).withExposedPorts(new Integer[]{COLLECTOR_OTLP_GRPC_PORT, COLLECTOR_OTLP_HTTP_PORT, COLLECTOR_OTLP_GRPC_MTLS_PORT, COLLECTOR_OTLP_HTTP_MTLS_PORT, COLLECTOR_HEALTH_CHECK_PORT}).waitingFor((WaitStrategy)Wait.forHttp((String)"/").forPort(COLLECTOR_HEALTH_CHECK_PORT.intValue()));
            this.collector.start();
            System.setProperty("mule.open.telemetry.exporter.enabled", Boolean.TRUE.toString());
            System.setProperty("mule.open.telemetry.exporter.type", this.exporterType);
            System.setProperty("mule.open.telemetry.exporter.endpoint", this.schema + this.collector.getHost() + ":" + this.collector.getMappedPort(this.port) + this.path);
            System.setProperty("mule.open.telemetry.exporter.tls.enabled", Boolean.toString(this.secure));
            if (this.secure) {
                System.setProperty("mule.open.telemetry.exporter.key.file.location", clientTls.privateKeyFile().toPath().toString());
                System.setProperty("mule.open.telemetry.exporter.cert.file.location", clientTls.certificateFile().toPath().toString());
                System.setProperty("mule.open.telemetry.exporter.ca.file.location", serverTls.certificateFile().toPath().toString());
            }
        });
    }

    @After
    public void after() {
        server.reset();
        System.clearProperty("mule.open.telemetry.exporter.enabled");
        System.clearProperty("mule.open.telemetry.exporter.type");
        System.clearProperty("mule.open.telemetry.exporter.endpoint");
    }

    protected List<CapturedExportedSpan> getSpans() {
        return server.getSpans();
    }

    private static final class TestGrpcServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/opentelemetry.proto.collector.trace.v1.TraceService/Export";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();

        private TestGrpcServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractUnaryGrpcService(){

                @NotNull
                protected CompletionStage<byte[]> handleMessage(@NotNull ServiceRequestContext ctx, byte @NotNull [] message) {
                    try {
                        capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((byte[])message)));
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new UncheckedIOException((IOException)((Object)e));
                    }
                    return CompletableFuture.completedFuture(ExportTraceServiceResponse.getDefaultInstance().toByteArray());
                }
            });
            sb.http(0);
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }

        public List<CapturedExportedSpan> getSpans() {
            return this.capturedExportedSpans;
        }
    }
}

