/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class AsyncSuccessTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_ASYNC_SPAN_NAME = "mule:async";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";
    public static final String ASYNC_FLOW = "async-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/async-success.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncFlow() throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            CountDownLatch asyncTerminationLatch = new CountDownLatch(1);
            FlowRunner runner = (FlowRunner)this.flowRunner(ASYNC_FLOW).withPayload((Object)"test");
            ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> asyncTerminationLatch.countDown());
            runner.run();
            asyncTerminationLatch.await();
            Collection exportedSpans = spanCapturer.getExportedSpans();
            Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)6));
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).child(EXPECTED_SET_VARIABLE_SPAN_NAME).child(EXPECTED_ASYNC_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

