/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class ChoiceRouterTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:choice:route";
    public static final String EXPECTED_CHOICE_SPAN_NAME = "mule:choice";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String EXPECTED_RAISE_ERROR_SPAN_NAME = "mule:raise-error";
    public static final String CHOICE_FLOW = "choice-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String TEST_ARTIFACT_ID = "ChoiceRouterTracingTestCase#testChoiceFlow";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/choice-router.xml";
    }

    @Test
    public void testChoiceFlow() throws Exception {
        this.testForRoute(EXPECTED_LOGGER_SPAN_NAME, false);
        this.testForRoute(EXPECTED_SET_PAYLOAD_SPAN_NAME, false);
        this.testForRoute(EXPECTED_RAISE_ERROR_SPAN_NAME, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testForRoute(String childExpectedSpan, boolean isError) throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        try {
            if (isError) {
                ((FlowRunner)this.flowRunner(CHOICE_FLOW).withPayload((Object)childExpectedSpan)).runExpectingException();
            } else {
                ((FlowRunner)this.flowRunner(CHOICE_FLOW).withPayload((Object)childExpectedSpan)).run().getMessage();
            }
            Collection exportedSpans = spanCapturer.getExportedSpans();
            if (isError) {
                Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)5));
            } else {
                Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)4));
            }
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CHOICE_FLOW, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CHOICE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"choice-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(childExpectedSpan).endChildren().endChildren();
            if (isError) {
                expectedSpanHierarchy.child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"unknown", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence);
            }
            expectedSpanHierarchy.endChildren();
            expectedSpanHierarchy.assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo(span.getAttributes().get("artifact.id"))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

