/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class FirstSuccessfulDoubleErrorTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_ROUTE_SPAN_NAME_ATTEMPT_1 = "mule:first-successful:attempt:1";
    public static final String EXPECTED_ROUTE_SPAN_NAME_ATTEMPT_2 = "mule:first-successful:attempt:2";
    public static final String EXPECTED_FIRST_SUCCESSFUL_SPAN_NAME = "mule:first-successful";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String FLOW = "first-successful-telemetryFlow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final int NUMBER_OF_ROUTES = 2;
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/first-successful-double-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW).withPayload((Object)"test")).dispatch();
            Collection exportedSpans = spanCapturer.getExportedSpans();
            Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)11));
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).child(EXPECTED_FIRST_SUCCESSFUL_SPAN_NAME).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME_ATTEMPT_1).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().child(EXPECTED_ROUTE_SPAN_NAME_ATTEMPT_2).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

