/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class ParallelForEachErrorTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:parallel-foreach:iteration";
    public static final String EXPECTED_PARALLEL_FOREACH_SPAN_NAME = "mule:parallel-foreach";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String PARALLEL_FOR_EACH_FLOW = "parallel-for-eachFlow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final int NUMBER_OF_ROUTES = 3;
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/parallel-foreach-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowWithError() throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(PARALLEL_FOR_EACH_FLOW).withPayload((Object)"test")).dispatch();
            Collection exportedSpans = spanCapturer.getExportedSpans();
            Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)13));
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_PARALLEL_FOREACH_SPAN_NAME).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

