/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class TryScopeSuccessfulTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String TRY_SCOPE_FLOW = "try-scope-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_TRY_SCOPE_SPAN_NAME = "mule:try";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String TEST_ARTIFACT_ID = "TryScopeSuccessfulTracingTestCase#testTryScope";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/try-scope-successful.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryScope() throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(TRY_SCOPE_FLOW).withPayload((Object)"test")).run().getMessage();
            Collection exportedSpans = spanCapturer.getExportedSpans();
            Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)3));
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)TRY_SCOPE_FLOW, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_TRY_SCOPE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"try-scope-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"try-scope-flow/processors/0/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren();
            expectedSpanHierarchy.assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo(span.getAttributes().get("artifact.id"))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

