/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class UntilSuccessfulErrorTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_ATTEMPT_SPAN_NAME = "mule:until-successful:attempt";
    public static final String EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME = "mule:until-successful";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String UNTIL_SUCCESSFUL_FLOW = "until-successful-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "http:request";
    public static final String ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final int NUMBER_OF_RETRIES = 2;
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/until-successful-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUntilSuccessfulFlowWithError() throws Exception {
        ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(UNTIL_SUCCESSFUL_FLOW).withPayload((Object)"test")).dispatch();
            Collection exportedSpans = spanCapturer.getExportedSpans();
            Assert.assertThat((Object)exportedSpans, (Matcher)Matchers.hasSize((int)12));
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_UNTIL_SUCCESSFUL_SPAN_NAME).beginChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_HTTP_REQUEST_SPAN_NAME).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_HTTP_REQUEST_SPAN_NAME).endChildren().child(EXPECTED_ATTEMPT_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).child(EXPECTED_HTTP_REQUEST_SPAN_NAME).endChildren().endChildren().child(ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            expectedSpanHierarchy.assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

