/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class CustomScopeSuccessfulTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_CUSTOM_SCOPE_SPAN_NAME = "heisenberg:execute-anything";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String CUSTOM_SCOPE_FLOW = "custom-scope-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String TEST_ARTIFACT_ID = "CustomScopeSuccessfulTracingTestCase#testCustomScopeFlow";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/custom-scope-success.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomScopeFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(CUSTOM_SCOPE_FLOW).withPayload((Object)"test")).run().getMessage();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 3;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_FLOW, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CUSTOM_SCOPE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren();
            expectedSpanHierarchy.assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo(span.getAttributes().get("artifact.id"))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

