/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class CustomSpanNameAndAttributesTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    public static final String EXPECTED_SOURCE_SPAN_NAME = "pet-store-list-modified";
    public static final String EXPECTED_CUSTOM_SPAN_NAME = "customSpanName";
    public static final String FLOW_CUSTOM_SPAN_NAME_AND_ATTRIBUTES = "flow-custom-span-name-and-attributes";
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    private ExportedSpanSniffer spanCapturer;
    @Inject
    PrivilegedProfilingService profilingService;

    @Before
    public void initialize() {
        this.spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
    }

    @After
    public void dispose() {
        this.spanCapturer.dispose();
    }

    protected String getConfigFile() {
        return "tracing/custom-span-name-and-attributes.xml";
    }

    @Test
    public void testCustomSpanNameAndAttributes() throws Exception {
        this.startFlow(FLOW_CUSTOM_SPAN_NAME_AND_ATTRIBUTES);
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = CustomSpanNameAndAttributesTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 2;
            }

            public String describeFailure() {
                return "No spans were captured";
            }
        });
        Collection exportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_SOURCE_SPAN_NAME).beginChildren().child(EXPECTED_CUSTOM_SPAN_NAME).endChildren();
        expectedSpanHierarchy.assertSpanTree();
        CapturedExportedSpan capturedExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_CUSTOM_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span with customSpanName found!"));
        Assert.assertThat((Object)capturedExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attributeAddedByAddCurrentSpanAttribute", (Object)"ok"));
        Assert.assertThat((Object)capturedExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"attributeAddedByAddCurrentSpanAttributes", (Object)"ok"));
        CapturedExportedSpan sourceExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_SOURCE_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No source exported span found!"));
        Assert.assertThat((Object)sourceExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)"dog", (Object)"Jack, the legendary fake border collie"));
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }
}

