/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class DistributedTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");
    private static final String STARTING_FLOW = "startingFlow";
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "HTTP GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "/test";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final int MAX_BACKOFF_ATTEMPTS = 2;
    private final String type;
    private final String path;
    @ClassRule
    public static final TestServerRule httpServer = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/distributed-tracing.xml";
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"HTTP", ""}});
    }

    public DistributedTracingTestCase(String type, String path) {
        this.type = type;
        this.path = path;
    }

    @Before
    public void before() {
        System.setProperty("mule.open.telemetry.exporter.enabled", Boolean.TRUE.toString());
        System.setProperty("mule.open.telemetry.exporter.type", this.type);
        System.setProperty("mule.open.telemetry.exporter.endpoint", "http://localhost:" + httpServer.httpPort() + "/" + this.path);
        System.setProperty("mule.open.telemetry.exporterbackoff.max.attempts", String.valueOf(2));
    }

    @After
    public void after() {
        System.clearProperty("mule.open.telemetry.exporter.enabled");
        System.clearProperty("mule.open.telemetry.exporter.type");
        System.clearProperty("mule.open.telemetry.exporter.endpoint");
        System.clearProperty("mule.open.telemetry.exporterbackoff.max.attempts");
    }

    @Test
    public void testDistributedTracing() throws Exception {
        this.flowRunner(STARTING_FLOW).run();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
                return exportedSpans.size() == 4;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).endChildren().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull HttpRequest req) {
                    return HttpResponse.from((CompletionStage)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }
    }
}

