/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class FlowErrorHandlingTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String ERROR_TYPE_1 = "CUSTOM:ERROR";
    public static final String ERROR_TYPE_2 = "CUSTOM:ERROR_2";
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:round-robin:route";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN = "mule:on-error-propagate";
    public static final String EXPECTED_ON_ERROR_CONTINUE_SPAN = "mule:on-error-continue";
    public static final String EXPECTED_FLOW_REF_SPAN = "mule:flow-ref";
    public static final String EXPECTED_SUBFLOW_SPAN = "mule:subflow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String TEST_ARTIFACT_ID = "FlowErrorHandlingTracingTestCase#flowWIthOnErrorPropagateAndOnErrorContinueComposition";
    private static final String FLOW_WITH_NO_ERROR_HANDLING = "flow-with-no-error-handling";
    private static final String FLOW_WITH_ON_ERROR_CONTINUE = "flow-with-on-error-continue";
    private static final String FLOW_WITH_ON_ERROR_PROPAGATE = "flow-with-on-error-propagate";
    private static final String FLOW_WITH_FLOW_REF_AND_NO_ERROR_HANDLING = "flow-with-flow-ref-and-no-error-handling";
    private static final String FLOW_WITH_FLOW_REF_AND_ON_ERROR_CONTINUE = "flow-with-flow-ref-and-on-error-continue";
    private static final String FLOW_WITH_FLOW_REF_AND_ON_ERROR_PROPAGATE = "flow-with-flow-ref-and-on-error-propagate";
    private static final String FLOW_WITH_FLOW_REF_AND_ON_ERROR_PROPAGATE_AND_ON_ERROR_CONTINUE = "flow-with-flow-ref-and-on-error-propagate-and-on-error-continue";
    private static final String FLOW_WITH_SUB_FLOW_REF_AND_ON_ERROR_CONTINUE = "flow-with-sub-flow-ref-and-on-error-continue";
    private static final String FLOW_WITH_SUB_FLOW_REF_AND_NO_ERROR_HANDLING = "flow-with-sub-flow-ref-and-no-error-handling";
    private static final String FLOW_WITH_FAILING_ON_ERROR_CONTINUE = "flow-with-failing-on-error-continue";
    private static final String FLOW_WITH_FAILING_ON_ERROR_PROPAGATE = "flow-with-failing-on-error-propagate";
    private static final String FLOW_WITH_ON_ERROR_PROPAGATE_AND_ON_ERROR_CONTINUE_COMPOSITION = "flow-with-on-error-propagate-and-on-error-continue-composition";
    private ExportedSpanSniffer spanCapturer;
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/flow-error-handling.xml";
    }

    @Before
    public void initialize() {
        this.spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
    }

    @After
    public void dispose() {
        this.spanCapturer.dispose();
    }

    @Test
    public void testFlowWithNoErrorHandling() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_NO_ERROR_HANDLING).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 3;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithOnErrorContinue() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_ON_ERROR_CONTINUE).withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 3;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_2).child(EXPECTED_ON_ERROR_CONTINUE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFailingOnErrorContinue() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FAILING_ON_ERROR_CONTINUE).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR_2"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 4;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_2).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_CONTINUE_SPAN).addExceptionData(ERROR_TYPE_2).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_2).endChildren().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFailingOnErrorPropagate() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FAILING_ON_ERROR_PROPAGATE).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR_2"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 4;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_2).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).addExceptionData(ERROR_TYPE_2).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_2).endChildren().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithOnErrorPropagate() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_ON_ERROR_PROPAGATE).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 3;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFlowRefAndNoErrorHandling() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FLOW_REF_AND_NO_ERROR_HANDLING).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 6;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_REF_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFlowRefAndOnErrorContinue() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FLOW_REF_AND_ON_ERROR_CONTINUE).withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 5;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_REF_SPAN).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_SPAN_NAME).noExceptionExpected().beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_2).child(EXPECTED_ON_ERROR_CONTINUE_SPAN).noExceptionExpected().endChildren().endChildren().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFlowRefAndOnErrorPropagate() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FLOW_REF_AND_ON_ERROR_PROPAGATE).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 6;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_REF_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithFlowRefAndOnErrorPropagateAndOnErrorContinue() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_FLOW_REF_AND_ON_ERROR_PROPAGATE_AND_ON_ERROR_CONTINUE).withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 6;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_REF_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren().endChildren().child(EXPECTED_ON_ERROR_CONTINUE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithSubFlowRefAndNoErrorHandling() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_SUB_FLOW_REF_AND_NO_ERROR_HANDLING).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 5;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_FLOW_REF_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_SUBFLOW_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void testFlowWithSubFlowRefAndOnErrorContinue() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_SUB_FLOW_REF_AND_ON_ERROR_CONTINUE).withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 5;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_REF_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_SUBFLOW_SPAN).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ERROR_TYPE_1).endChildren().endChildren().child(EXPECTED_ON_ERROR_CONTINUE_SPAN).noExceptionExpected().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }

    @Test
    public void flowWIthOnErrorPropagateAndOnErrorContinueComposition() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_WITH_ON_ERROR_PROPAGATE_AND_ON_ERROR_CONTINUE_COMPOSITION).withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"CUSTOM", (String)"ERROR"));
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                Collection exportedSpans = FlowErrorHandlingTracingTestCase.this.spanCapturer.getExportedSpans();
                return exportedSpans.size() == 7;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        Collection capturedExportedSpans = this.spanCapturer.getExportedSpans();
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(capturedExportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(ERROR_TYPE_1).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"flow-with-on-error-propagate-and-on-error-continue-composition/processors/0", (String)TEST_ARTIFACT_ID)).addExceptionData(ERROR_TYPE_1).child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_REF_SPAN).noExceptionExpected().beginChildren().child(EXPECTED_FLOW_SPAN_NAME).noExceptionExpected().beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"flow-with-on-error-continue/processors/0", (String)TEST_ARTIFACT_ID)).addExceptionData(ERROR_TYPE_2).child(EXPECTED_ON_ERROR_CONTINUE_SPAN).noExceptionExpected().endChildren().endChildren().endChildren().endChildren();
        expectedSpanHierarchy.assertSpanTree();
    }
}

