/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class HttpSemanticConventionAttributesAndNameTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String STARTING_FLOW = "startingFlow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "HTTP GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "/test";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String NET_PEER_NAME = "net.peer.name";
    public static final String NET_PEER_PORT = "net.peer.port";
    public static final String HTTP_URL = "http.url";
    public static final String HTTP_METHOD = "http.method";
    public static final String HTTP_FLAVOR = "http.flavor";
    public static final String NET_HOST_NAME = "net.host.name";
    public static final String HTTP_TARGET = "http.target";
    public static final String HTTP_USER_AGENT = "http.user_agent";
    public static final String NET_HOST_PORT = "net.host.port";
    public static final String HTTP_SCHEME = "http.scheme";
    public static final String HTTP_STATUS_CODE = "http.status_code";
    public static final String SPAN_KIND_ATTRIBUTE = "span.kind.override";
    @Inject
    PrivilegedProfilingService profilingService;
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "tracing/http-semantic-conventions-tracing.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            this.flowRunner(STARTING_FLOW).run();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 4;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).endChildren().endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan listenerExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_FLOW_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http listener flow found!"));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)14));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_NAME, (Object)"0.0.0.0"));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_TARGET, (Object)EXPECTED_HTTP_FLOW_SPAN_NAME));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_SCHEME, (Object)"http"));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_USER_AGENT, (Object)"AHC/1.0"));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_HOST_PORT, (Object)this.httpPort.getValue()));
            Assert.assertThat((Object)listenerExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            Assert.assertThat(listenerExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE), (Matcher)Matchers.nullValue());
            Assert.assertThat((Object)listenerExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"SERVER"));
            CapturedExportedSpan requestExportedSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_HTTP_REQUEST_SPAN_NAME)).findFirst().orElseThrow(() -> new AssertionFailedError("No span for http request flow found!"));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.aMapWithSize((int)13));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_NAME, (Object)"localhost"));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)NET_PEER_PORT, (Object)this.httpPort.getValue()));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_URL, (Object)("http://localhost:" + this.httpPort.getValue() + EXPECTED_HTTP_FLOW_SPAN_NAME)));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_METHOD, (Object)"GET"));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_FLAVOR, (Object)"1.1"));
            Assert.assertThat((Object)requestExportedSpan.getAttributes(), (Matcher)Matchers.hasEntry((Object)HTTP_STATUS_CODE, (Object)"200"));
            Assert.assertThat(requestExportedSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE), (Matcher)Matchers.nullValue());
            Assert.assertThat((Object)requestExportedSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CLIENT"));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

