/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class RoundRobinErrorTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:round-robin:route";
    public static final String EXPECTED_ROUND_ROBIN_SPAN_NAME = "mule:round-robin";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String ROUND_ROBIN_FLOW = "round-robin-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN = "mule:on-error-propagate";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String TEST_ARTIFACT_ID = "RoundRobinErrorTracingTestCase#testRoundRobinFlowWithError";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/round-robin-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundRobinFlowWithError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(ROUND_ROBIN_FLOW).withPayload((Object)"test")).runExpectingException();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 6;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)ROUND_ROBIN_FLOW, (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUND_ROBIN_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0/route/0/processors/0", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"round-robin-flow/processors/0/route/0/processors/1", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"unknown", (String)TEST_ARTIFACT_ID)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo(span.getAttributes().get("artifact.id"))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

