/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import javax.inject.Inject;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.TracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class ScatterGatherErrorTracingTestCase
extends MuleArtifactFunctionalTestCase
implements TracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_ROUTE_SPAN_NAME = "mule:scatter-gather:route";
    public static final String EXPECTED_SCATTER_GATHER_SPAN_NAME = "mule:scatter-gather";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String SCATTER_GATHER_FLOW = "scatter-gather-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    public static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    @Inject
    PrivilegedProfilingService profilingService;

    protected String getConfigFile() {
        return "tracing/scatter-gather-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScatterGatherFlowWithError() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(SCATTER_GATHER_FLOW).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 8;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_RAISE_ERROR_SPAN).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME);
            expectedSpanHierarchy.assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

