/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String FLOW_NAME = "scatter-gather-flow";
    private static final String CONFIG_FILE = "tracing/scatter-gather-double-error.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/scatter-gather";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SCATTER_GATHER_SPAN_NAME = "mule:scatter-gather";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:scatter-gather:route";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String EXPECTED_RAISE_ERROR_SPAN = "mule:raise-error";
    private static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    private static final String ANY_EXPECTED_ERROR_TYPE = "ANY:EXPECTED";
    private static final String MULE_COMPOSITE_ROUTING_ERROR_TYPE = "MULE:COMPOSITE_ROUTING";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-scatter-gather-debug", 7, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy()}, {"overview-scatter-gather-monitoring", 7, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-debug", 8, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy()}, {"monitoring-scatter-gather-overview", 2, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy()}, {"debug-scatter-gather-monitoring", 8, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getDebugScatterGatherMonitoringExpectedSpanTestHierarchy()}, {"debug-scatter-gather-overview", 2, OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getDebugScatterGatherOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase(String tracingLevelConf, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = tracingLevelConf;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewScatterGatherDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getOverviewScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringScatterGatherDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SCATTER_GATHER_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_RAISE_ERROR_SPAN).addExceptionData(ANY_EXPECTED_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData(MULE_COMPOSITE_ROUTING_ERROR_TYPE).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugScatterGatherMonitoringExpectedSpanTestHierarchy() {
        return OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugScatterGatherOverviewExpectedSpanTestHierarchy() {
        return OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.getMonitoringScatterGatherOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideScatterGatherDoubleErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans()).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

