/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing.override;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class OverrideParallelForEachSuccessOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String CONFIG_FILE = "tracing/parallel-foreach-success.xml";
    private static final String OVERRIDE_FOLDER_NAME = "override/parallel-foreach";
    private static final String FLOW_NAME = "parallel-for-eachFlow";
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_PARALLEL_FOREACH_SPAN_NAME = "mule:parallel-foreach";
    private static final String EXPECTED_ROUTE_SPAN_NAME = "mule:parallel-foreach:iteration";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private final String tracingLevelConf;
    private final int expectedSpansCount;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="TracingLevelConf: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"overview-parallel-foreach-debug", 11, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getOverviewParallelForeachDebugExpectedSpanTestHierarchy()}, {"overview-parallel-foreach-monitoring", 11, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getOverviewParallelForeachMonitoringExpectedSpanTestHierarchy()}, {"monitoring-parallel-foreach-debug", 13, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getMonitoringParallelForeachDebugExpectedSpanTestHierarchy()}, {"monitoring-parallel-foreach-overview", 3, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getMonitoringParallelForeachOverviewExpectedSpanTestHierarchy()}, {"debug-parallel-foreach-monitoring", 13, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getDebugParallelForeachMonitoringExpectedSpanTestHierarchy()}, {"debug-parallel-foreach-overview", 3, OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getDebugParallelForeachOverviewExpectedSpanTestHierarchy()});
    }

    public OverrideParallelForEachSuccessOpenTelemetryTracingTestCase(String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevelConf = traceLevel;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        String separator = FileSystems.getDefault().getSeparator();
        String tracingLevelConfigurationPath = String.format("%s%s%s%s", OVERRIDE_FOLDER_NAME, separator, this.tracingLevelConf, separator);
        System.setProperty("mule.tracing.level.configuration.path", tracingLevelConfigurationPath);
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewParallelForeachDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_PARALLEL_FOREACH_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewParallelForeachMonitoringExpectedSpanTestHierarchy() {
        return OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getOverviewParallelForeachDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringParallelForeachDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_PARALLEL_FOREACH_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ROUTE_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringParallelForeachOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugParallelForeachMonitoringExpectedSpanTestHierarchy() {
        return OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getMonitoringParallelForeachDebugExpectedSpanTestHierarchy();
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugParallelForeachOverviewExpectedSpanTestHierarchy() {
        return OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.getMonitoringParallelForeachOverviewExpectedSpanTestHierarchy();
    }

    @Test
    public void testFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).dispatch();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == OverrideParallelForEachSuccessOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured.";
                }
            });
            this.spanHierarchyRetriever.apply(spanCapturer.getExportedSpans()).assertSpanTree();
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

