/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.AbstractFullOpenTelemetryTracingTestCase;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class SimpleFullOpenTelemetryTracingTestCase
extends AbstractFullOpenTelemetryTracingTestCase {
    @Rule
    public SystemProperty defaultTracingLevel = new SystemProperty("mule.openTelemetry.tracer.exporter.defaultTracingLevel", "monitoring");
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    private static final String EXPECTED_TRACING_CORRELATION_ID_SPAN_NAME = "tracing:with-correlation-id";
    private static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";
    private static final String EXPECTED_SET_LOGGING_VARIABLE_SPAN_NAME = "tracing:set-logging-variable";
    private static final String SIMPLE_FLOW = "simple-flow";
    private static final String CORRELATION_ID_KEY = "correlation.id";
    private static final String TEST_ARTIFACT_ID = "SimpleFullOpenTelemetryTracingTestCase#testSimpleFlow";
    private static final String FLOW_LOCATION = "simple-flow";
    private static final String SET_PAYLOAD_LOCATION = "simple-flow/processors/2";
    private static final String SET_VARIABLE_LOCATION = "simple-flow/processors/0/processors/0";
    private static final String SET_LOGGING_VARIABLE_LOCATION = "simple-flow/processors/1";
    private static final String TRACING_SET_CORRELATION_ID_LOCATION = "simple-flow/processors/0";
    private static final String TEST_VAR_NAME = "testVar";
    private static final String TRACE_VAR_VALUE = "Hello World!";
    private static final String CORRELATION_ID_CUSTOM_VALUE = "Fua";

    public SimpleFullOpenTelemetryTracingTestCase(String exporterType, String schema, boolean secure) {
        super(exporterType, schema, secure);
    }

    protected String getConfigFile() {
        return "tracing/simple-flow.xml";
    }

    @Test
    public void testSimpleFlow() throws Exception {
        ((FlowRunner)this.flowRunner("simple-flow").withPayload((Object)"test")).run().getMessage();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = SimpleFullOpenTelemetryTracingTestCase.this.getSpans();
                return exportedSpans.size() == 5;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        List<CapturedExportedSpan> exportedSpans = this.getSpans();
        List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
        String artifactId = "SimpleFullOpenTelemetryTracingTestCase#testSimpleFlow[type: " + this.exporterType + " - path: " + this.path + " - secure: " + this.secure + "]";
        Map setPayloadAttributeMap = TracingTestUtils.createAttributeMap((String)SET_PAYLOAD_LOCATION, (String)artifactId);
        setPayloadAttributeMap.put(TEST_VAR_NAME, TRACE_VAR_VALUE);
        Map setVariableAttributeMap = TracingTestUtils.createAttributeMap((String)SET_VARIABLE_LOCATION, (String)artifactId);
        setVariableAttributeMap.put(CORRELATION_ID_KEY, CORRELATION_ID_CUSTOM_VALUE);
        SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
        expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"simple-flow", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_TRACING_CORRELATION_ID_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)TRACING_SET_CORRELATION_ID_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_SET_VARIABLE_SPAN_NAME).addAttributesToAssertValue(setVariableAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_SET_LOGGING_VARIABLE_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)SET_LOGGING_VARIABLE_LOCATION, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_SET_PAYLOAD_SPAN_NAME).addAttributesToAssertValue(setPayloadAttributeMap).addAttributesToAssertExistence(attributesToAssertExistence).endChildren();
        expectedSpanHierarchy.assertSpanTree();
        exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)artifactId)));
    }
}

