/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class OpenTelemetryJmsSemanticConventionAttributesAndNameTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "GET /";
    public static final String EXPECTED_JMS_PUBLISH_NAME = "test_queue send";
    public static final String EXPECTED_JMS_CONSUME_NAME = "test_queue receive";
    private static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
    public static final String MESSAGING_SYSTEM = "messaging.system";
    public static final String MESSAGING_DESTINATION = "messaging.destination";
    public static final String MESSAGING_DESTINATION_KIND = "messaging.destination_kind";
    public static final String SPAN_KIND_ATTRIBUTE = "span.kind.override";
    @Inject
    PrivilegedProfilingService profilingService;
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "tracing/jms-semantic-conventions-tracing.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="W-16571574")
    public void testFlow() throws IOException, TimeoutException {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            this.httpClient.send(HttpRequest.builder().uri(String.format("http://localhost:%s/", this.httpPort.getNumber())).build());
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == 4;
                }

                public String describeFailure() {
                    return String.format("The exact amount of spans was not captured. Captured spans: %s", spanCapturer.getExportedSpans().toString());
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            HashMap<String, String> jmsExpectedAttributes = new HashMap<String, String>();
            jmsExpectedAttributes.put(MESSAGING_SYSTEM, "activemq");
            jmsExpectedAttributes.put(MESSAGING_DESTINATION, "test_queue");
            jmsExpectedAttributes.put(MESSAGING_DESTINATION_KIND, "queue");
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_HTTP_FLOW_SPAN_NAME).beginChildren().child(EXPECTED_SET_PAYLOAD_SPAN_NAME).child(EXPECTED_JMS_PUBLISH_NAME).addAttributesToAssertValue(jmsExpectedAttributes).child(EXPECTED_JMS_CONSUME_NAME).addAttributesToAssertValue(jmsExpectedAttributes).endChildren();
            expectedSpanHierarchy.assertSpanTree();
            CapturedExportedSpan jmsPublishSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_JMS_PUBLISH_NAME)).findFirst().get();
            CapturedExportedSpan jmsConsumeSpan = exportedSpans.stream().filter(exportedSpan -> exportedSpan.getName().equals(EXPECTED_JMS_CONSUME_NAME)).findFirst().get();
            MatcherAssert.assertThat((Object)jmsPublishSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"PRODUCER"));
            MatcherAssert.assertThat((Object)jmsPublishSpan.getAttributes().size(), (Matcher)Matchers.equalTo((Object)10));
            MatcherAssert.assertThat((Object)((String)jmsPublishSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((Object)jmsConsumeSpan.getSpanKindName(), (Matcher)Matchers.equalTo((Object)"CONSUMER"));
            MatcherAssert.assertThat((Object)jmsConsumeSpan.getAttributes().size(), (Matcher)Matchers.equalTo((Object)10));
            MatcherAssert.assertThat((Object)((String)jmsConsumeSpan.getAttributes().get(SPAN_KIND_ATTRIBUTE)), (Matcher)Matchers.nullValue());
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

