/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingSnifferTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.infrastructure.profiling.tracing.TracingTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
@RunnerDelegateTo(value=Parameterized.class)
public class CustomScopeErrorOpenTelemetryTracingTestCase
extends OpenTelemetryTracingSnifferTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    public static final String EXPECTED_CUSTOM_SCOPE_SPAN_NAME = "heisenberg:execute-anything";
    public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    public static final String CUSTOM_SCOPE_FLOW = "custom-scope-flow";
    public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
    public static final String NO_PARENT_SPAN = "0000000000000000";
    private static final String EXPECTED_RAISE_ERROR_SPAN_NAME = "mule:raise-error";
    private static final String EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME = "mule:on-error-propagate";
    public static final String TEST_ARTIFACT_ID = "CustomScopeErrorOpenTelemetryTracingTestCase#testCustomScopeFlow";
    private final String tracingLevel;
    private final int expectedSpansCount;
    private final BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever;
    @Inject
    PrivilegedProfilingService profilingService;

    @Parameterized.Parameters(name="tracingLevel: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({TracingLevel.OVERVIEW.name(), 1, CustomScopeErrorOpenTelemetryTracingTestCase.getOverviewExpectedSpanTestHierarchy()}, {TracingLevel.MONITORING.name(), 5, CustomScopeErrorOpenTelemetryTracingTestCase.getMonitoringExpectedSpanTestHierarchy()}, {TracingLevel.DEBUG.name(), 9, CustomScopeErrorOpenTelemetryTracingTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    public CustomScopeErrorOpenTelemetryTracingTestCase(String tracingLevel, int expectedSpansCount, BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> spanHierarchyRetriever) {
        this.tracingLevel = tracingLevel;
        this.expectedSpansCount = expectedSpansCount;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_FLOW, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence);
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_FLOW, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CUSTOM_SCOPE_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0/processors/1", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static BiFunction<Collection<CapturedExportedSpan>, String, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return (exportedSpans, artifactId) -> {
            List attributesToAssertExistence = TracingTestUtils.getDefaultAttributesToAssertExistence();
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)CUSTOM_SCOPE_FLOW, (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child(EXPECTED_CUSTOM_SCOPE_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).beginChildren().child("mule:parameters-resolution").beginChildren().child("mule:value-resolution").child("mule:value-resolution").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0/processors/0", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).child(EXPECTED_RAISE_ERROR_SPAN_NAME).addExceptionData("ANY:EXPECTED").addAttributesToAssertValue(TracingTestUtils.createAttributeMap((String)"custom-scope-flow/processors/0/processors/1", (String)artifactId)).addAttributesToAssertExistence(attributesToAssertExistence).endChildren().endChildren().child(EXPECTED_ON_ERROR_PROPAGATE_SPAN_NAME).endChildren();
            return expectedSpanHierarchy;
        };
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.tracing.level.configuration.path", this.tracingLevel.toLowerCase() + FileSystems.getDefault().getSeparator());
        super.doSetUpBeforeMuleContextCreation();
    }

    @After
    public void doAfter() {
        System.clearProperty("mule.tracing.level.configuration.path");
    }

    protected String getConfigFile() {
        return "tracing/custom-scope-error.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomScopeFlow() throws Exception {
        final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
        try {
            ((FlowRunner)this.flowRunner(CUSTOM_SCOPE_FLOW).withPayload((Object)"test")).runExpectingException();
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    Collection exportedSpans = spanCapturer.getExportedSpans();
                    return exportedSpans.size() == CustomScopeErrorOpenTelemetryTracingTestCase.this.expectedSpansCount;
                }

                public String describeFailure() {
                    return "The exact amount of spans was not captured";
                }
            });
            Collection exportedSpans = spanCapturer.getExportedSpans();
            this.spanHierarchyRetriever.apply(exportedSpans, "CustomScopeErrorOpenTelemetryTracingTestCase#testCustomScopeFlow[tracingLevel: " + this.tracingLevel + "]").assertSpanTree();
            exportedSpans.forEach(span -> Assert.assertThat((Object)span.getServiceName(), (Matcher)Matchers.equalTo((Object)((String)span.getAttributes().get("artifact.id")))));
        }
        finally {
            spanCapturer.dispose();
        }
    }
}

