/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit4.server.ServerRule;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracing.level.api.config.TracingLevel;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryProtobufSpanUtils;
import org.mule.test.components.tracing.OpenTelemetryTracingTestCase;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Feature(value="Profiling")
@Story(value="Default Core Event Tracer")
public class TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase
extends OpenTelemetryTracingTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    public static final String ROOT_SPAN_NAME = "rootSpan";
    private final String traceLevel;
    private final Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever;
    @Rule
    public SystemProperty addAncestorSpanId = new SystemProperty("mule.enable.mule.specific.tracing.information", "false");
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");
    @Rule
    public DynamicPort entryListenerPort = new DynamicPort("entryListenerPort");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();
    private static final String EXPECTED_HTTP_REQUEST_SPAN_NAME = "GET";
    private static final String EXPECTED_HTTP_FLOW_SPAN_NAME = "GET /test";
    private static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
    private static final String EXPECTED_FLOW_SPAN_NAME = "GET /entry";
    private static final String EXPECTED_VALUE_RESOLUTION_SPAN_NAME = "mule:value-resolution";
    private static final String EXPECTED_PARAMETERS_RESOLUTION_SPAN_NAME = "mule:parameters-resolution";
    public static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    private final String type;
    private final String path;
    private int expectedSpansCount;
    @Rule
    public SystemProperty openTelemetryExporterType = new SystemProperty("mule.openTelemetry.tracer.exporter.type", "HTTP");
    @Rule
    public SystemProperty openTelemetryExporterEndpoint = new SystemProperty("mule.openTelemetry.tracer.exporter.endpoint", "http://localhost:" + httpServer.httpPort() + "/");
    @ClassRule
    public static final TestServerRule httpServer = new TestServerRule();

    protected String getConfigFile() {
        return "tracing/distributed-tracing.xml";
    }

    @Parameterized.Parameters(name="Transport: {0} - Tracing Level: {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"HTTP", "", TracingLevel.OVERVIEW.name(), 4, TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase.getOverviewExpectedSpanTestHierarchy()}, {"HTTP", "", TracingLevel.MONITORING.name(), 5, TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase.getMonitoringExpectedSpanTestHierarchy()}, {"HTTP", "", TracingLevel.DEBUG.name(), 20, TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase.getDebugExpectedSpanTestHierarchy()});
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getOverviewExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(ROOT_SPAN_NAME).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getMonitoringExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(ROOT_SPAN_NAME).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_LOGGER_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    private static Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> getDebugExpectedSpanTestHierarchy() {
        return exportedSpans -> {
            SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
            expectedSpanHierarchy.withRoot(ROOT_SPAN_NAME).beginChildren().child(EXPECTED_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_HTTP_REQUEST_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child("mule:get-connection").addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_PARAMETERS_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").beginChildren().child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").child(EXPECTED_VALUE_RESOLUTION_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").endChildren().child("mule:operation-execution").beginChildren().child(EXPECTED_HTTP_FLOW_SPAN_NAME).addTraceStateKeyValueAssertion("key1", "value1").addTraceStateKeyValueAssertion("key2", "value2").addTraceStateKeyValueAssertion("ancestor-mule-span-id", "1").endChildren().endChildren().endChildren().endChildren();
            return expectedSpanHierarchy;
        };
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        System.setProperty("mule.tracing.level.configuration.path", this.traceLevel.toLowerCase() + FileSystems.getDefault().getSeparator());
        super.doSetUpBeforeMuleContextCreation();
    }

    public TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase(String type, String path, String traceLevel, int expectedSpansCount, Function<Collection<CapturedExportedSpan>, SpanTestHierarchy> spanHierarchyRetriever) {
        this.type = type;
        this.path = path;
        this.expectedSpansCount = expectedSpansCount;
        this.traceLevel = traceLevel;
        this.spanHierarchyRetriever = spanHierarchyRetriever;
    }

    @After
    public void after() {
        System.clearProperty("mule.tracing.level.configuration.path");
        httpServer.reset();
    }

    @Test
    public void traceStatePropagation() throws Exception {
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().build();
        Tracer tracer = openTelemetry.getTracer("testing-instrumentation-library", "1.0.0");
        Span span = tracer.spanBuilder(ROOT_SPAN_NAME).startSpan();
        TextMapSetter setter = (carrier, key, value) -> carrier.put((Object)key, (Object)value);
        MultiMap headers = new MultiMap();
        W3CTraceContextPropagator.getInstance().inject(Context.current().with((ImplicitContextKeyed)span), (Object)headers, setter);
        httpServer.getCapturedExportedSpans().add(new RootTestCapturedSpan(ROOT_SPAN_NAME, span));
        headers.put((Object)"tracestate", (Object)"key1=value1,key2=value2,ancestor-mule-span-id=1");
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%s/entry", this.entryListenerPort.getNumber())).headers(headers)).method(HttpConstants.Method.GET).build();
        org.mule.runtime.http.api.domain.message.response.HttpResponse response = this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(30000).build());
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)HttpStatus.OK.code()));
        span.end();
        PollingProber prober = new PollingProber(30000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() {
                List<CapturedExportedSpan> exportedSpans = httpServer.getCapturedExportedSpans();
                return exportedSpans.size() == TraceStatePropagationWithSpecificTraceInfoFlagDisabledTestCase.this.expectedSpansCount;
            }

            public String describeFailure() {
                return "The exact amount of spans was not captured";
            }
        });
        this.spanHierarchyRetriever.apply(httpServer.getCapturedExportedSpans()).assertSpanTree();
    }

    private class RootTestCapturedSpan
    implements CapturedExportedSpan {
        private final Span span;
        private final String name;

        public RootTestCapturedSpan(String name, Span span) {
            this.name = name;
            this.span = span;
        }

        public String getName() {
            return this.name;
        }

        public String getParentSpanId() {
            return Span.getInvalid().getSpanContext().getSpanId();
        }

        public String getSpanId() {
            return this.span.getSpanContext().getSpanId();
        }

        public String getTraceId() {
            return this.span.getSpanContext().getTraceId();
        }

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public String getServiceName() {
            return null;
        }

        public String getSpanKindName() {
            return SpanKind.INTERNAL.toString();
        }

        public List<CapturedEventData> getEvents() {
            return Collections.emptyList();
        }

        public boolean hasErrorStatus() {
            return false;
        }

        public String getStatusAsString() {
            return StatusCode.UNSET.toString();
        }

        public long getStartEpochSpanNanos() {
            return 0L;
        }

        public long getEndSpanEpochNanos() {
            return 1L;
        }

        public Map<String, String> getTraceState() {
            return Collections.emptyMap();
        }
    }

    private static final class TestServerRule
    extends ServerRule {
        public static final String PATH_PATTERN = "/";
        private final List<CapturedExportedSpan> capturedExportedSpans = new ArrayList<CapturedExportedSpan>();

        private TestServerRule() {
        }

        protected void configure(ServerBuilder sb) {
            sb.service(PATH_PATTERN, (com.linecorp.armeria.server.HttpService)new AbstractHttpService(){

                @NotNull
                protected HttpResponse doPost(@NotNull ServiceRequestContext ctx, @NotNull com.linecorp.armeria.common.HttpRequest req) {
                    return HttpResponse.from((CompletionStage)req.aggregate().handle((aReq, cause) -> {
                        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
                        HttpResponse res = HttpResponse.from(responseFuture);
                        try {
                            capturedExportedSpans.addAll(OpenTelemetryProtobufSpanUtils.getSpans(ExportTraceServiceRequest.parseFrom((InputStream)new ByteArrayInputStream(aReq.content().array()))));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        responseFuture.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                        return res;
                    }));
                }
            });
            sb.http(0);
        }

        public List<CapturedExportedSpan> getCapturedExportedSpans() {
            return this.capturedExportedSpans;
        }

        public void reset() {
            this.capturedExportedSpans.clear();
        }
    }
}

