/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterFactory;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.tracing.OpenTelemetryTracingTestRunnerConfigAnnotation;

@Feature(value="Profiling")
@Story(value="Open Telemetry Exporter")
public abstract class OpenTelemetrySamplerTestCase
extends MuleArtifactFunctionalTestCase
implements OpenTelemetryTracingTestRunnerConfigAnnotation {
    public static final int REQUESTS = 10;
    public static final int EXPECTED_EVALUATED_SPANS = 2;
    @Inject
    PrivilegedProfilingService profilingService;
    private final TestSamplerSpanExporter spanExporter = new TestSamplerSpanExporter();
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 100;
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();
    @Rule
    public SystemProperty systemPropertySampler = new SystemProperty("mule.openTelemetry.tracer.exporter.sampler", this.getSamplerName());
    @Rule
    public SystemProperty systemPropertySamplerArg = new SystemProperty("mule.openTelemetry.tracer.exporter.sampler.arg", this.getSamplerArg());
    @Rule
    public DynamicPort entryListenerPort = new DynamicPort("httpPort");
    @Rule
    public SystemProperty defaultTracingLevel = new SystemProperty("mule.openTelemetry.tracer.exporter.defaultTracingLevel", "monitoring");
    @Rule
    public SystemProperty enableSniffing = new SystemProperty("mule.openTelemetry.tracer.exporter.use.sniffer", Boolean.TRUE.toString());
    @Rule
    public SystemProperty enableTracingExport = new SystemProperty("mule.openTelemetry.tracer.exporter.enabled", "true");

    protected String getConfigFile() {
        return "tracing/simple-flow-sampling.xml";
    }

    @Test
    public void test() throws Exception {
        Assume.assumeThat((Object)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11), (Matcher)CoreMatchers.is((Object)true));
        for (int i = 0; i < 10; ++i) {
            final ExportedSpanSniffer spanCapturer = this.profilingService.getSpanExportManager().getExportedSpanSniffer();
            MultiMap headers = new MultiMap();
            if (!this.isRemoteRequestSpanSampled()) {
                OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().build();
                Tracer tracer = openTelemetry.getTracer("testing-instrumentation-library", "1.0.0");
                Span span = tracer.spanBuilder("root").startSpan();
                TextMapSetter setter = (carrier, key, value) -> carrier.put((Object)key, (Object)value);
                span = Span.wrap((SpanContext)SpanContext.create((String)span.getSpanContext().getTraceId(), (String)span.getSpanContext().getSpanId(), (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault()));
                W3CTraceContextPropagator.getInstance().inject(Context.current().with((ImplicitContextKeyed)span), (Object)headers, setter);
            }
            HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%s/", this.entryListenerPort.getNumber())).headers(headers)).method(HttpConstants.Method.GET).build();
            this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(30000).build());
            PollingProber prober = new PollingProber(30000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    return OpenTelemetrySamplerTestCase.this.spanExporter.getEvaluatedSpans() == 2;
                }

                public String describeFailure() {
                    return "The exact amount of evaluated spans did not occurred";
                }
            });
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() {
                    return spanCapturer.getExportedSpans().size() == OpenTelemetrySamplerTestCase.this.expectedSpan();
                }

                public String describeFailure() {
                    return "The amount of exported spans is not correct. Exported: " + spanCapturer.getExportedSpans().size() + ", Expected: " + OpenTelemetrySamplerTestCase.this.expectedSpan();
                }
            });
            this.spanExporter.clear();
        }
    }

    private int expectedSpan() {
        return !this.isRemoteRequestSpanSampled() ? 0 : this.spanExporter.getSampledCount();
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(this.getCustomSpanExporterFactoryBuilder());
    }

    abstract String getSamplerName();

    abstract String getSamplerArg();

    private ConfigurationBuilder getCustomSpanExporterFactoryBuilder() {
        return new ConfigurationBuilder(){

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }

            public void configure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleCoreExporterFactory", (Object)OpenTelemetrySamplerTestCase.this.spanExporter);
            }
        };
    }

    protected boolean isRemoteRequestSpanSampled() {
        return true;
    }

    private static class TestSamplerSpanExporter
    extends OpenTelemetrySpanExporterFactory {
        private TestSamplerWrapper sampler;

        private TestSamplerSpanExporter() {
        }

        protected Sampler resolveSampler() {
            this.sampler = new TestSamplerWrapper(super.resolveSampler());
            return this.sampler;
        }

        protected SpanExporter resolveOpenTelemetrySpanExporter() {
            return super.resolveOpenTelemetrySpanExporter();
        }

        public int getSampledCount() {
            return this.sampler.getSampledCount();
        }

        public int getEvaluatedSpans() {
            return this.sampler.getEvaluatedSpans();
        }

        public void clear() {
            this.sampler.clear();
        }

        private static final class TestSamplerWrapper
        implements Sampler {
            private final Sampler sampler;
            private final List<String> evaluatedSpans = new ArrayList<String>();
            private final List<String> sampledSpans = new ArrayList<String>();

            public TestSamplerWrapper(Sampler sampler) {
                this.sampler = sampler;
            }

            public SamplingResult shouldSample(Context context, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> list) {
                SamplingResult samplingResult = this.sampler.shouldSample(context, traceId, name, spanKind, attributes, list);
                String spanTestKey = this.transformSpanNameIfMuleFlowSemanticVersion(name);
                if (samplingResult.getDecision().equals((Object)SamplingDecision.RECORD_AND_SAMPLE)) {
                    if (!this.sampledSpans.contains(spanTestKey)) {
                        this.sampledSpans.add(spanTestKey);
                    }
                } else if (this.sampledSpans.contains(spanTestKey)) {
                    this.sampledSpans.remove(spanTestKey);
                }
                if (!this.evaluatedSpans.contains(spanTestKey)) {
                    this.evaluatedSpans.add(spanTestKey);
                }
                return samplingResult;
            }

            private String transformSpanNameIfMuleFlowSemanticVersion(String name) {
                if (name.contains("GET")) {
                    return "mule:flow";
                }
                return name;
            }

            public String getDescription() {
                return "Test sampler wrapper";
            }

            public int getSampledCount() {
                return this.sampledSpans.size();
            }

            public int getEvaluatedSpans() {
                return this.evaluatedSpans.size();
            }

            public void clear() {
                this.evaluatedSpans.clear();
                this.sampledSpans.clear();
            }
        }
    }
}

